# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .catalog_item import CatalogItem


class USqlCredential(CatalogItem):
    """A Data Lake Analytics catalog U-SQL credential item.

    :param compute_account_name: the name of the Data Lake Analytics account.
    :type compute_account_name: str
    :param version: the version of the catalog item.
    :type version: str
    :param database_name: the name of the database the credential is in.
    :type database_name: str
    :param identity: the name of the secret associated with the credential.
    :type identity: str
    :param name: the name of the credential.
    :type name: str
    :param user_name: the user name associated with the credential.
    :type user_name: str
    """ 

    _attribute_map = {
        'compute_account_name': {'key': 'computeAccountName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'str'},
        'name': {'key': 'credentialName', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
    }

    def __init__(self, compute_account_name=None, version=None, database_name=None, identity=None, name=None, user_name=None):
        super(USqlCredential, self).__init__(compute_account_name=compute_account_name, version=version)
        self.database_name = database_name
        self.identity = identity
        self.name = name
        self.user_name = user_name
