# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class User(Resource):
    """Represents user crendentials used for publishing activity.

    :param id: Resource Id
    :type id: str
    :param name: Resource Name
    :type name: str
    :param kind: Kind of resource
    :type kind: str
    :param location: Resource Location
    :type location: str
    :param type: Resource type
    :type type: str
    :param tags: Resource tags
    :type tags: dict
    :param user_name: Username (internal)
    :type user_name: str
    :param publishing_user_name: Username used for publishing
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing
    :type publishing_password: str
    :param scm_uri: Service Control Manager URI, including username and
     password
    :type scm_uri: str
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'user_name': {'key': 'properties.name', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'scm_uri': {'key': 'properties.scmUri', 'type': 'str'},
    }

    def __init__(self, location, id=None, name=None, kind=None, type=None, tags=None, user_name=None, publishing_user_name=None, publishing_password=None, scm_uri=None):
        super(User, self).__init__(id=id, name=name, kind=kind, location=location, type=type, tags=tags)
        self.user_name = user_name
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.scm_uri = scm_uri
