# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Sku(Model):
    """Sku parameters supplied to the create redis operation.

    :param name: What type of redis cache to deploy. Valid values: (Basic,
     Standard, Premium). Possible values include: 'Basic', 'Standard',
     'Premium'
    :type name: str or :class:`SkuName <azure.mgmt.redis.models.SkuName>`
    :param family: Which family to use. Valid values: (C, P). Possible values
     include: 'C', 'P'
    :type family: str or :class:`SkuFamily
     <azure.mgmt.redis.models.SkuFamily>`
    :param capacity: What size of redis cache to deploy. Valid values: for C
     family (0, 1, 2, 3, 4, 5, 6), for P family (1, 2, 3, 4)
    :type capacity: int
    """ 

    _validation = {
        'name': {'required': True},
        'family': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, name, family, capacity):
        self.name = name
        self.family = family
        self.capacity = capacity
