# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .integration_account_resource import IntegrationAccountResource


class IntegrationAccountPartner(IntegrationAccountResource):
    """IntegrationAccountPartner.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: The resource id.
    :type id: str
    :param name: The resource name.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict
    :param partner_type: The partner type. Possible values include:
     'NotSpecified', 'B2B'
    :type partner_type: str or :class:`PartnerType
     <azure.mgmt.logic.models.PartnerType>`
    :ivar created_time: The created time.
    :vartype created_time: datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: datetime
    :param metadata: The metadata.
    :type metadata: object
    :param content: The partner content.
    :type content: :class:`PartnerContent
     <azure.mgmt.logic.models.PartnerContent>`
    """ 

    _validation = {
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_type': {'key': 'properties.partnerType', 'type': 'PartnerType'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'content': {'key': 'properties.content', 'type': 'PartnerContent'},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, partner_type=None, metadata=None, content=None):
        super(IntegrationAccountPartner, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.partner_type = partner_type
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.content = content
