# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TaskIdRange(Model):
    """A range of task ids that a task can depend on. All tasks with ids in the
    range must complete successfully before the dependent task can be
    scheduled.

    :param start: The first task id in the range.
    :type start: int
    :param end: The last task id in the range.
    :type end: int
    """ 

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'start', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
    }

    def __init__(self, start, end):
        self.start = start
        self.end = end
