# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import os
import gtk
import consts
import dlgChooseFiles

# The two strings stored in the ListStore object
(
    CELL_DISPLAYED_FILENAME,
    CELL_COMPLETE_FILENAME,
) = range(2)



class TreeViewCreate :

    def __init__(self, parentWindow, treeview) :
        self.mTreeview     = treeview
        self.mParentWindow = parentWindow

        self.wTree = gtk.glade.XML(os.path.join(consts.dirRes, 'creationpopupmenus.glade'))
        self.wTree.signal_autoconnect(self)

        # (Displayed string, Complete filename)
        self.storage = gtk.ListStore(str, str)
        self.mTreeview.set_model(self.storage)
        self.mTreeview.insert_column_with_attributes(-1, '', gtk.CellRendererText(), text=CELL_DISPLAYED_FILENAME)


    def hasSelection(self) :
        model, iter = self.mTreeview.get_selection().get_selected()
        return iter != None


    def setFocusAtXY(self, x, y) :
        self.mTreeview.grab_focus()
        pthinfo = self.mTreeview.get_path_at_pos(x, y)
        # Select the row if any, clear selection otherwise
        if pthinfo is not None :
            path, col, cellx, celly = pthinfo
            self.mTreeview.set_cursor(path)
        elif self.hasSelection() :
            path, col = self.mTreeview.get_cursor()
            self.mTreeview.get_selection().unselect_path(path)


    def addFile(self, file) :
        if file.startswith(consts.dirUsr) :
            self.storage.append([file.replace(consts.dirUsr, '~', 1), file])
        else :
            self.storage.append([file, file])


    def removeSelection(self) :
        model, iter = self.mTreeview.get_selection().get_selected()
        if iter is not None :
            model.remove(iter)


    def getAllFilenames(self) :
        return [file[CELL_COMPLETE_FILENAME] for file in self.storage]


    def onMouseButton(self, tree, event) :
        # Single right click ?
        if event.button == 3 and event.type == gtk.gdk.BUTTON_PRESS :
            self.setFocusAtXY(int(event.x), int(event.y))

            if self.hasSelection() :
                self.wTree.get_widget('menuAll').popup(None, None, None, event.button, event.time)
            elif len(self.storage) is not 0 :
                self.wTree.get_widget('menuAddClear').popup(None, None, None, event.button, event.time)
            else :
                self.wTree.get_widget('menuAdd').popup(None, None, None, event.button, event.time)


    def onKey(self, tree, event) :
        if gtk.gdk.keyval_name(event.keyval) == 'Delete' :
            self.removeSelection()


    def onAddDirectoryContent(self, widget) :
        dlgChooseFiles.instance(self.mParentWindow).setModeToDirectory()
        directories = dlgChooseFiles.instance(self.mParentWindow).show()
        if directories is not None :
            for directory in directories :
                for filename in os.listdir(directory) :
                    file = directory + '/' + filename
                    if os.path.isfile(file) :
                        self.addFile(file)


    def onAddFiles(self, widget) :
        dlgChooseFiles.instance(self.mParentWindow).setModeToFiles()
        files = dlgChooseFiles.instance(self.mParentWindow).show()
        if files is not None :
            for file in files :
                self.addFile(file)


    def onRemoveSelected(self, widget) :
        self.removeSelection()


    def onRemoveAll(self, widget) :
        self.storage.clear()
