# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk
import consts

from dlgBase import DlgBase
from gettext import gettext as _

class DlgChooseFiles(DlgBase) :

    def __init__(self, parent) :
        DlgBase.__init__(self, parent, 'dlg-choosefiles')

        self.mFileChooser = self.wTree.get_widget('dlg-choosefiles')
        self.mFileChooser.set_current_folder(consts.dirUsr)
        self.mFileChooser.set_transient_for(parent)


    def setModeToFiles(self) :
        self.mFileChooser.set_action(gtk.FILE_CHOOSER_ACTION_OPEN)
        self.mFileChooser.set_title(_('Select file(s)'))
        self.mFileChooser.set_select_multiple(True)


    def setModeToDirectory(self) :
        self.mFileChooser.set_action(gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        self.mFileChooser.set_title(_('Select directory'))
        self.mFileChooser.set_select_multiple(False)


    def show(self) :
        if self.mFileChooser.run() == gtk.RESPONSE_OK :
            return self.mFileChooser.get_filenames()
        return None


dlg = None
def instance(parent) :
    global dlg
    if dlg == None :
        dlg = DlgChooseFiles(parent)
    return dlg
