# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk
import consts
import os.path

from gettext import gettext as _

def show(parent) :
    dlg = gtk.AboutDialog()
    dlg.set_transient_for(parent)

    dlg.set_name(consts.appName)
    dlg.set_version(consts.appVersion)
    dlg.set_website(consts.appURL)

    dlg.set_authors([
        _('Developer:'),
        'Ingelrest François <Athropos@gmail.com>',
        '',
        _('Thanks to:'),
        'Piotr Ozarowski',
        'Ludovic Biancotto',
    ])

    dlg.set_translator_credits(_('translator-credits'))
    
    if os.path.exists(consts.fileLicense) :
        license = open(consts.fileLicense).read()  # Licence is read from the disk
        dlg.set_license(license)
        dlg.set_wrap_license(True)

    dlg.run()
    dlg.destroy()
