#include "portable.h"
#include <stdio.h>
#include "slap.h"
#include "external.h"
#include "nws_back_cache.h"
#include "nws_back.h"


int
nws_back_db_open(BackendDB *bd)
{
  ldap_pvt_thread_t lpt;
  nwsBackConfig *nbc;

  Debug(LDAP_DEBUG_TRACE,"==>nws_back_db_open()\n",0,0,0);

  nbc = (nwsBackConfig *)bd->be_private;

  if (!nbc)  {
	Debug(LDAP_DEBUG_TRACE,"nws_back_init: be_private is NULL.\n",0,0,0);
	exit(1);
  }

  nbc->max_data_entries = 32;
  nbc->max_forc_entries = 32;
  nbc->initial_fetch_size = 10;
  nbc->min_refresh_period = 60;



  /* ldap output init */
  if (nwsLdapInit(nbc) < 0) {
	printf("nwsLdapInit() failed.  This could indicate a problem with the schema file.\n");
	exit(-1);
  }

  /* series cache init */
  nbc->nser = malloc(sizeof(struct nws_series_cache));
  nbc->nser->name = strdup("head");
  nbc->nser->next = NULL;
  nbc->nser->prev = nbc->nser;

  nbc->nser_root = nbc->nser;

  /* series collection init */
  nbc->nser_coll = malloc(sizeof(struct nws_series_collection));
  nbc->nser_coll->name = strdup("head");
  nbc->nser_coll->member = malloc(sizeof(char *));
  /* nbc->nser_coll->member[0] = NULL; */
  nbc->nser_coll->series_rel = malloc(sizeof(struct nws_series_cache2coll *));
  /* nbc->nser_coll->series[0] = NULL; */

  pthread_mutex_init(&nbc->reg_objs_mutex, NULL);
  pthread_mutex_init(&nbc->obj_list_mutex, NULL);
  pthread_mutex_init(&nbc->nser_coll_mutex, NULL);
  pthread_mutex_init(&nbc->nws_connect_mutex, NULL);

  nbc->ns_cookie.sd = NO_SOCKET; 

  /*
  ldap_pvt_thread_mutex_lock(&nbc->nws_connect_mutex);
  if(!ConnectToHost(&nbc->ns_cookie, &nbc->ns_cookie.sd)) {
	printf("ConnectToHost failed for %s.\n", nbc->ns_cookie.name);
	exit(0);
  }
  ldap_pvt_thread_mutex_unlock(&nbc->nws_connect_mutex);
  */

  ldap_pvt_thread_create(&lpt, 1, (nws_cache_getreg), (void *)nbc);

  Debug(LDAP_DEBUG_TRACE,"<==nws_back_db_open()\n",0,0,0);
  return 0;
}
