#include "portable.h"
#include <stdio.h>
#include <ac/socket.h>
#include "slap.h"
#include "external.h"
#include "nws_back_cache.h"
#include "nws_back.h"

/* #define PROTOCOL 1 */

int
nws_back_abandon(BackendDB *be, Connection *conn, Operation *op, int msgid );

int
nws_back_destroy(Backend *be, Connection *conn);


#define SLAPD_NWS_DYNAMIC 1

#ifdef SLAPD_NWS_DYNAMIC 

int libback_nws_LTX_init_module(int argc, char *argv[]) {
    BackendInfo bi;

    memset( &bi, '\0', sizeof(bi) );
    bi.bi_type = strdup("nws");
    bi.bi_init = nws_back_initialize;

    backend_add(&bi);
    return 0;
}

#endif /* SLAPD_NWS_DYNAMIC */

int
nws_back_initialize(BackendInfo	*bi)
{
  Debug(LDAP_DEBUG_TRACE,"==>nws_back_initialize()\n",0,0,0);

  bi->bi_config = 0;
  bi->bi_open = 0;
  bi->bi_close = 0;
  bi->bi_destroy = 0;

  bi->bi_db_init = nws_back_init;
  bi->bi_db_config = nws_back_db_config;
  bi->bi_db_open = nws_back_db_open;
  bi->bi_db_close = 0;
  bi->bi_db_destroy = 0;

  bi->bi_op_bind = 0;
  bi->bi_op_unbind = nws_back_unbind;
  bi->bi_op_search = nws_back_search;
  bi->bi_op_compare = 0;
  bi->bi_op_modify = nws_back_modify;
  bi->bi_op_modrdn = 0;
  bi->bi_op_add = 0;
  bi->bi_op_delete = 0;
  bi->bi_op_abandon = nws_back_abandon;

  bi->bi_extended = 0;

  bi->bi_acl_group = 0;
  bi->bi_acl_attribute = 0;
  bi->bi_chk_referrals = 0;

  bi->bi_connection_init = 0;
  bi->bi_connection_destroy = nws_back_destroy;

  Debug(LDAP_DEBUG_TRACE,"<==nws_back_initialize()\n",0,0,0);
  return 0;
}

int 
nws_back_init(BackendDB *bd)
{
  nwsBackConfig *nbc;

  Debug(LDAP_DEBUG_TRACE,"==>nws_back_init()\n",0,0,0);

  bd->be_sizelimit = 65536;
  
  if ((nbc = (nwsBackConfig *)malloc(sizeof(nwsBackConfig)))== NULL) {
	perror("malloc of nwsBackConfig failed");
	exit(-1);
  }

  nbc->nws_obj_list = NULL;
  nbc->nws_reg_objs = NULL;
  nbc->nws_forecaster = NULL;
  
  if ((nbc->arch_list = (archiveTarget **)malloc(sizeof(archiveTarget *)))
	  == NULL) {
	perror("malloc of nbc->arch_list failed");
	exit(-1);
  }
  nbc->arch_list[0] = NULL;
  nbc->arch_count = 0;

  if ((nbc->grid_list = (gridTarget **)malloc(sizeof(gridTarget *)))
          == NULL) {
        perror("malloc of nbc->grid_list failed");
        exit(-1);
  }
  nbc->grid_list[0] = NULL;
  nbc->grid_count = 0;

  /* series collection RB tree */
  nbc->nser_coll_tree = make_rb();

#ifdef PROTOCOL

  if((nbc->proto=nws_back_soap_init(nbc)) == NULL) {
	printf("SOAP Protocol init failed. (nws_back_soap_init returned NULL)\n");
	exit(-1);
  }

#endif /* PROTOCOL */  
 
  bd->be_private = (void *)nbc;
  bd->bd_info->bi_private = bd->be_private;

  if (!nbc)  {
	Debug(LDAP_DEBUG_TRACE,"nws_back_init: be_private is NULL.\n",0,0,0);
	exit(1);
  }

  Debug(LDAP_DEBUG_TRACE,"<==nws_back_init()\n",0,0,0);
  return 0;
}

int
nws_back_abandon( BackendDB *be,
				  Connection *conn, Operation *op, int msgid ) {
  Debug(LDAP_DEBUG_TRACE,"==>nws_back_abandon()\n",0,0,0);
  Debug(LDAP_DEBUG_TRACE,"<==nws_back_abandon()\n",0,0,0);
  return 0;
}

int
nws_back_destroy(Backend *be, Connection *conn) {
  Debug(LDAP_DEBUG_TRACE,"==>nws_back_destroy()\n",0,0,0);
  Debug(LDAP_DEBUG_TRACE,"<==nws_back_destroy()\n",0,0,0);
  return 0;
}
