#include <fe/njamd.h>
#include <fe/util/err.h>

void err(int ret, const char* format, ...)
{
	va_list ap;

	va_start(ap, format);
	verr(ret, format, ap);
}

void verr(int ret, const char* format, va_list cmds)
{
	if (format) {
		vfprintf(stderr, format, cmds);
		fprintf(stderr, "\n");
	}

	exit(ret);
}

void warn(const char* format, ...)
{
	va_list ap;

	va_start(ap, format);
	vwarn(format, ap);
	va_end(ap);
}

void vwarn(const char* format, va_list cmds)
{
	if (format) {
		vfprintf(stderr, format, cmds);
		fprintf(stderr, "\n");
	}
}
