// Variable definition class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "VariableDefinition.h"
#include "Marking.h"
#include "VectorType.h"
#include "VectorValue.h"
#include "StructType.h"
#include "StructValue.h"
#include "UnionType.h"
#include "UnionValue.h"

#include <assert.h>
#include "util.h"

/** @file VariableDefinition.C
 * A variable that can be assigned a value in a Valuation
 */

/* Copyright  1999-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

VariableDefinition::VariableDefinition () :
  myName (0), myType (0), myIsAggregate (false), myIsUndefined (false),
  myIsReferenced (false), myIsHidden (false),
#ifdef EXPR_COMPILE
  myNumber (0),
#endif // EXPR_COMPILE
  myChildMap (), myFather (0)
{
}

VariableDefinition::VariableDefinition (char* name,
					const class Type& type,
					bool aggregate,
					bool hidden) :
  myName (name), myType (&type),
  myIsAggregate (aggregate), myIsUndefined (false),
  myIsReferenced (false), myIsHidden (hidden),
#ifdef EXPR_COMPILE
  myNumber (0),
#endif // EXPR_COMPILE
  myChildMap (), myFather (0)
{
  assert (myName && myType);
}

VariableDefinition::VariableDefinition (const class VariableDefinition& old) :
  myName (old.myName ? newString (old.myName) : 0),
  myType (old.myType),
  myIsAggregate (old.myIsAggregate), myIsUndefined (old.myIsUndefined),
  myIsReferenced (old.myIsReferenced), myIsHidden (old.myIsHidden),
#ifdef EXPR_COMPILE
  myNumber (0),
#endif // EXPR_COMPILE
  myChildMap (), myFather (0)
{
#ifdef EXPR_COMPILE
  assert (!old.myNumber);
#endif // EXPR_COMPILE
}

VariableDefinition::~VariableDefinition ()
{
  delete[] myName;
  for (ChildMap::iterator i = myChildMap.begin (); i != myChildMap.end (); i++)
    delete i->second;
}

const class VariableDefinition*
VariableDefinition::findChild (const char* name) const
{
  assert (isAggregate ());
  ChildMap::const_iterator i = myChildMap.find (const_cast<char*>(name));
  return i == myChildMap.end () ? 0 : i->second;
}

const class VariableDefinition*
VariableDefinition::addChild (char* name,
			      const class Type& type) const
{
  assert (isAggregate ());
  ChildMap::iterator i = myChildMap.find (name);
  class VariableDefinition* child;
  if (i == myChildMap.end ()) {
    child = new class VariableDefinition (name, type, false, myIsHidden);
    child->myFather = this;
    myChildMap.insert (ChildMap::value_type (name, child));
    return child;
  }
  else {
    child = i->second;
    delete[] name;
    if (child->myType != &type)
      return 0;
    return child;
  }
}
