/* logger.c generated by valac 0.14.2, the Vala compiler
 * generated from logger.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>


#define FSO_FRAMEWORK_TYPE_LOGGER (fso_framework_logger_get_type ())
#define FSO_FRAMEWORK_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLogger))
#define FSO_FRAMEWORK_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_LOGGER))
#define FSO_FRAMEWORK_LOGGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_FRAMEWORK_TYPE_LOGGER, FsoFrameworkLoggerIface))

typedef struct _FsoFrameworkLogger FsoFrameworkLogger;
typedef struct _FsoFrameworkLoggerIface FsoFrameworkLoggerIface;

#define FSO_FRAMEWORK_TYPE_SMART_KEY_FILE (fso_framework_smart_key_file_get_type ())
#define FSO_FRAMEWORK_SMART_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFile))
#define FSO_FRAMEWORK_SMART_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFileClass))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE))
#define FSO_FRAMEWORK_SMART_KEY_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFileClass))

typedef struct _FsoFrameworkSmartKeyFile FsoFrameworkSmartKeyFile;
typedef struct _FsoFrameworkSmartKeyFileClass FsoFrameworkSmartKeyFileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER (fso_framework_abstract_logger_get_type ())
#define FSO_FRAMEWORK_ABSTRACT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, FsoFrameworkAbstractLogger))
#define FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, FsoFrameworkAbstractLoggerClass))
#define FSO_FRAMEWORK_IS_ABSTRACT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER))
#define FSO_FRAMEWORK_IS_ABSTRACT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER))
#define FSO_FRAMEWORK_ABSTRACT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, FsoFrameworkAbstractLoggerClass))

typedef struct _FsoFrameworkAbstractLogger FsoFrameworkAbstractLogger;
typedef struct _FsoFrameworkAbstractLoggerClass FsoFrameworkAbstractLoggerClass;

#define FSO_FRAMEWORK_TYPE_FILE_LOGGER (fso_framework_file_logger_get_type ())
#define FSO_FRAMEWORK_FILE_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_FILE_LOGGER, FsoFrameworkFileLogger))
#define FSO_FRAMEWORK_FILE_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_FILE_LOGGER, FsoFrameworkFileLoggerClass))
#define FSO_FRAMEWORK_IS_FILE_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_FILE_LOGGER))
#define FSO_FRAMEWORK_IS_FILE_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_FILE_LOGGER))
#define FSO_FRAMEWORK_FILE_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_FILE_LOGGER, FsoFrameworkFileLoggerClass))

typedef struct _FsoFrameworkFileLogger FsoFrameworkFileLogger;
typedef struct _FsoFrameworkFileLoggerClass FsoFrameworkFileLoggerClass;

#define FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER (fso_framework_std_err_logger_get_type ())
#define FSO_FRAMEWORK_STD_ERR_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER, FsoFrameworkStdErrLogger))
#define FSO_FRAMEWORK_STD_ERR_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER, FsoFrameworkStdErrLoggerClass))
#define FSO_FRAMEWORK_IS_STD_ERR_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER))
#define FSO_FRAMEWORK_IS_STD_ERR_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER))
#define FSO_FRAMEWORK_STD_ERR_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER, FsoFrameworkStdErrLoggerClass))

typedef struct _FsoFrameworkStdErrLogger FsoFrameworkStdErrLogger;
typedef struct _FsoFrameworkStdErrLoggerClass FsoFrameworkStdErrLoggerClass;

#define FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER (fso_framework_syslog_logger_get_type ())
#define FSO_FRAMEWORK_SYSLOG_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER, FsoFrameworkSyslogLogger))
#define FSO_FRAMEWORK_SYSLOG_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER, FsoFrameworkSyslogLoggerClass))
#define FSO_FRAMEWORK_IS_SYSLOG_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER))
#define FSO_FRAMEWORK_IS_SYSLOG_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER))
#define FSO_FRAMEWORK_SYSLOG_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER, FsoFrameworkSyslogLoggerClass))

typedef struct _FsoFrameworkSyslogLogger FsoFrameworkSyslogLogger;
typedef struct _FsoFrameworkSyslogLoggerClass FsoFrameworkSyslogLoggerClass;

#define FSO_FRAMEWORK_TYPE_KMSG_LOGGER (fso_framework_kmsg_logger_get_type ())
#define FSO_FRAMEWORK_KMSG_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_KMSG_LOGGER, FsoFrameworkKmsgLogger))
#define FSO_FRAMEWORK_KMSG_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_KMSG_LOGGER, FsoFrameworkKmsgLoggerClass))
#define FSO_FRAMEWORK_IS_KMSG_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_KMSG_LOGGER))
#define FSO_FRAMEWORK_IS_KMSG_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_KMSG_LOGGER))
#define FSO_FRAMEWORK_KMSG_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_KMSG_LOGGER, FsoFrameworkKmsgLoggerClass))

typedef struct _FsoFrameworkKmsgLogger FsoFrameworkKmsgLogger;
typedef struct _FsoFrameworkKmsgLoggerClass FsoFrameworkKmsgLoggerClass;

#define FSO_FRAMEWORK_TYPE_NULL_LOGGER (fso_framework_null_logger_get_type ())
#define FSO_FRAMEWORK_NULL_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_NULL_LOGGER, FsoFrameworkNullLogger))
#define FSO_FRAMEWORK_NULL_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_NULL_LOGGER, FsoFrameworkNullLoggerClass))
#define FSO_FRAMEWORK_IS_NULL_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_NULL_LOGGER))
#define FSO_FRAMEWORK_IS_NULL_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_NULL_LOGGER))
#define FSO_FRAMEWORK_NULL_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_NULL_LOGGER, FsoFrameworkNullLoggerClass))

typedef struct _FsoFrameworkNullLogger FsoFrameworkNullLogger;
typedef struct _FsoFrameworkNullLoggerClass FsoFrameworkNullLoggerClass;
typedef struct _FsoFrameworkAbstractLoggerPrivate FsoFrameworkAbstractLoggerPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _FsoFrameworkNullLoggerPrivate FsoFrameworkNullLoggerPrivate;
typedef struct _FsoFrameworkFileLoggerPrivate FsoFrameworkFileLoggerPrivate;
typedef struct _FsoFrameworkStdErrLoggerPrivate FsoFrameworkStdErrLoggerPrivate;
typedef struct _FsoFrameworkSyslogLoggerPrivate FsoFrameworkSyslogLoggerPrivate;
typedef struct _FsoFrameworkKmsgLoggerPrivate FsoFrameworkKmsgLoggerPrivate;

#define TYPE_GLIB_LOGGER (glib_logger_get_type ())
#define GLIB_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLIB_LOGGER, GLibLogger))
#define GLIB_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLIB_LOGGER, GLibLoggerClass))
#define IS_GLIB_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLIB_LOGGER))
#define IS_GLIB_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLIB_LOGGER))
#define GLIB_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLIB_LOGGER, GLibLoggerClass))

typedef struct _GLibLogger GLibLogger;
typedef struct _GLibLoggerClass GLibLoggerClass;
typedef struct _GLibLoggerPrivate GLibLoggerPrivate;

typedef gchar* (*ReprDelegate) (void* user_data);
struct _FsoFrameworkLoggerIface {
	GTypeInterface parent_iface;
	void (*setLevel) (FsoFrameworkLogger* self, GLogLevelFlags level);
	void (*setDestination) (FsoFrameworkLogger* self, const gchar* destination);
	void (*setReprDelegate) (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target);
	GLogLevelFlags (*getLevel) (FsoFrameworkLogger* self);
	gchar* (*getDestination) (FsoFrameworkLogger* self);
	gboolean (*debug) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*info) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*warning) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*error) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*critical) (FsoFrameworkLogger* self, const gchar* message);
	gboolean (*data) (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
};

struct _FsoFrameworkAbstractLogger {
	GObject parent_instance;
	FsoFrameworkAbstractLoggerPrivate * priv;
	guint level;
	gchar* domain;
	gchar* destination;
	gboolean colored;
	ReprDelegate reprdelegate;
	gpointer reprdelegate_target;
	GDestroyNotify reprdelegate_target_destroy_notify;
};

struct _FsoFrameworkAbstractLoggerClass {
	GObjectClass parent_class;
	void (*write) (FsoFrameworkAbstractLogger* self, const gchar* message);
	gchar* (*format) (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level);
};

struct _FsoFrameworkNullLogger {
	FsoFrameworkAbstractLogger parent_instance;
	FsoFrameworkNullLoggerPrivate * priv;
};

struct _FsoFrameworkNullLoggerClass {
	FsoFrameworkAbstractLoggerClass parent_class;
};

struct _FsoFrameworkFileLogger {
	FsoFrameworkAbstractLogger parent_instance;
	FsoFrameworkFileLoggerPrivate * priv;
};

struct _FsoFrameworkFileLoggerClass {
	FsoFrameworkAbstractLoggerClass parent_class;
};

struct _FsoFrameworkFileLoggerPrivate {
	gint file;
};

struct _FsoFrameworkStdErrLogger {
	FsoFrameworkFileLogger parent_instance;
	FsoFrameworkStdErrLoggerPrivate * priv;
};

struct _FsoFrameworkStdErrLoggerClass {
	FsoFrameworkFileLoggerClass parent_class;
};

struct _FsoFrameworkSyslogLogger {
	FsoFrameworkAbstractLogger parent_instance;
	FsoFrameworkSyslogLoggerPrivate * priv;
};

struct _FsoFrameworkSyslogLoggerClass {
	FsoFrameworkAbstractLoggerClass parent_class;
};

struct _FsoFrameworkKmsgLogger {
	FsoFrameworkAbstractLogger parent_instance;
	FsoFrameworkKmsgLoggerPrivate * priv;
};

struct _FsoFrameworkKmsgLoggerClass {
	FsoFrameworkAbstractLoggerClass parent_class;
};

struct _FsoFrameworkKmsgLoggerPrivate {
	gint kmsg_fd;
};

struct _GLibLogger {
	GObject parent_instance;
	GLibLoggerPrivate * priv;
};

struct _GLibLoggerClass {
	GObjectClass parent_class;
};

struct _GLibLoggerPrivate {
	FsoFrameworkLogger* logger;
};


extern FsoFrameworkLogger* fso_framework_theLogger;
static gpointer fso_framework_abstract_logger_parent_class = NULL;
static FsoFrameworkLoggerIface* fso_framework_abstract_logger_fso_framework_logger_parent_iface = NULL;
static gpointer fso_framework_null_logger_parent_class = NULL;
static gpointer fso_framework_file_logger_parent_class = NULL;
static gpointer fso_framework_std_err_logger_parent_class = NULL;
static gpointer fso_framework_syslog_logger_parent_class = NULL;
static gchar* fso_framework_syslog_logger_basename;
static gchar* fso_framework_syslog_logger_basename = NULL;
static gpointer fso_framework_kmsg_logger_parent_class = NULL;
static gpointer glib_logger_parent_class = NULL;

#define DEFAULT_LOG_TYPE "stderr"
#define DEFAULT_LOG_LEVEL "INFO"
#define DEFAULT_LOG_DESTINATION "/tmp/frameworkd.log"
#define ENV_OVERRIDE_LOG_TO "FSO_LOG_TO"
#define ENV_OVERRIDE_LOG_DESTINATION "FSO_LOG_DESTINATION"
#define ENV_OVERRIDE_LOG_LEVEL "FSO_LOG_LEVEL"
GType fso_framework_logger_get_type (void) G_GNUC_CONST;
void fso_framework_logger_setLevel (FsoFrameworkLogger* self, GLogLevelFlags level);
void fso_framework_logger_setDestination (FsoFrameworkLogger* self, const gchar* destination);
void fso_framework_logger_setReprDelegate (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target);
GLogLevelFlags fso_framework_logger_getLevel (FsoFrameworkLogger* self);
gchar* fso_framework_logger_getDestination (FsoFrameworkLogger* self);
gboolean fso_framework_logger_debug (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_logger_info (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_logger_warning (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_logger_error (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_logger_critical (FsoFrameworkLogger* self, const gchar* message);
gboolean fso_framework_logger_data (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
FsoFrameworkLogger* fso_framework_logger_defaultLogger (void);
FsoFrameworkLogger* fso_framework_logger_createLogger (const gchar* group, const gchar* domain);
GType fso_framework_smart_key_file_get_type (void) G_GNUC_CONST;
FsoFrameworkLogger* fso_framework_logger_createFromKeyFile (FsoFrameworkSmartKeyFile* smk, const gchar* group, const gchar* domain);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_defaultKeyFile (void);
FsoFrameworkLogger* fso_framework_logger_createFromConfig (const gchar* filename, const gchar* group, const gchar* domain);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_createFromConfig (const gchar* filename);
FsoFrameworkLogger* fso_framework_logger_createFromKeyFileName (const gchar* filename, const gchar* group, const gchar* domain);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_new (void);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_construct (GType object_type);
gboolean fso_framework_smart_key_file_loadFromFile (FsoFrameworkSmartKeyFile* self, const gchar* filename);
gchar* fso_framework_smart_key_file_stringValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, const gchar* defaultvalue);
FsoFrameworkStdErrLogger* fso_framework_std_err_logger_new (const gchar* domain);
FsoFrameworkStdErrLogger* fso_framework_std_err_logger_construct (GType object_type, const gchar* domain);
GType fso_framework_abstract_logger_get_type (void) G_GNUC_CONST;
GType fso_framework_file_logger_get_type (void) G_GNUC_CONST;
GType fso_framework_std_err_logger_get_type (void) G_GNUC_CONST;
FsoFrameworkFileLogger* fso_framework_file_logger_new (const gchar* domain);
FsoFrameworkFileLogger* fso_framework_file_logger_construct (GType object_type, const gchar* domain);
void fso_framework_file_logger_setFile (FsoFrameworkFileLogger* self, const gchar* filename, gboolean append);
void fso_framework_abstract_logger_setColored (FsoFrameworkAbstractLogger* self, gboolean on);
FsoFrameworkSyslogLogger* fso_framework_syslog_logger_new (const gchar* domain);
FsoFrameworkSyslogLogger* fso_framework_syslog_logger_construct (GType object_type, const gchar* domain);
GType fso_framework_syslog_logger_get_type (void) G_GNUC_CONST;
FsoFrameworkKmsgLogger* fso_framework_kmsg_logger_new (const gchar* domain);
FsoFrameworkKmsgLogger* fso_framework_kmsg_logger_construct (GType object_type, const gchar* domain);
GType fso_framework_kmsg_logger_get_type (void) G_GNUC_CONST;
FsoFrameworkNullLogger* fso_framework_null_logger_new (const gchar* domain);
FsoFrameworkNullLogger* fso_framework_null_logger_construct (GType object_type, const gchar* domain);
GType fso_framework_null_logger_get_type (void) G_GNUC_CONST;
GLogLevelFlags fso_framework_abstract_logger_stringToLevel (const gchar* level);
enum  {
	FSO_FRAMEWORK_ABSTRACT_LOGGER_DUMMY_PROPERTY
};
void fso_framework_abstract_logger_write (FsoFrameworkAbstractLogger* self, const gchar* message);
static void fso_framework_abstract_logger_real_write (FsoFrameworkAbstractLogger* self, const gchar* message);
gchar* fso_framework_abstract_logger_colorwrap (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level);
gchar* fso_framework_abstract_logger_format (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level);
static gchar* fso_framework_abstract_logger_real_format (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level);
FsoFrameworkAbstractLogger* fso_framework_abstract_logger_construct (GType object_type, const gchar* domain);
static void fso_framework_abstract_logger_real_setLevel (FsoFrameworkLogger* base, GLogLevelFlags level);
static GLogLevelFlags fso_framework_abstract_logger_real_getLevel (FsoFrameworkLogger* base);
static void fso_framework_abstract_logger_real_setDestination (FsoFrameworkLogger* base, const gchar* destination);
static gchar* fso_framework_abstract_logger_real_getDestination (FsoFrameworkLogger* base);
gboolean fso_framework_abstract_logger_getColored (FsoFrameworkAbstractLogger* self);
static void fso_framework_abstract_logger_real_setReprDelegate (FsoFrameworkLogger* base, ReprDelegate d, void* d_target);
static gboolean fso_framework_abstract_logger_real_debug (FsoFrameworkLogger* base, const gchar* message);
static gboolean fso_framework_abstract_logger_real_info (FsoFrameworkLogger* base, const gchar* message);
static gboolean fso_framework_abstract_logger_real_warning (FsoFrameworkLogger* base, const gchar* message);
static gboolean fso_framework_abstract_logger_real_error (FsoFrameworkLogger* base, const gchar* message);
static gboolean fso_framework_abstract_logger_real_critical (FsoFrameworkLogger* base, const gchar* message);
static gboolean fso_framework_abstract_logger_real_data (FsoFrameworkLogger* base, guint8* message, int message_length1, gboolean in, GLogLevelFlags when);
gchar* fso_framework_abstract_logger_levelToString (GLogLevelFlags level);
static void fso_framework_abstract_logger_finalize (GObject* obj);
enum  {
	FSO_FRAMEWORK_NULL_LOGGER_DUMMY_PROPERTY
};
static void fso_framework_null_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message);
#define FSO_FRAMEWORK_FILE_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_FILE_LOGGER, FsoFrameworkFileLoggerPrivate))
enum  {
	FSO_FRAMEWORK_FILE_LOGGER_DUMMY_PROPERTY
};
static void fso_framework_file_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message);
static void fso_framework_file_logger_finalize (GObject* obj);
enum  {
	FSO_FRAMEWORK_STD_ERR_LOGGER_DUMMY_PROPERTY
};
enum  {
	FSO_FRAMEWORK_SYSLOG_LOGGER_DUMMY_PROPERTY
};
static void fso_framework_syslog_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message);
static gchar* fso_framework_syslog_logger_real_format (FsoFrameworkAbstractLogger* base, const gchar* message, const gchar* level);
gchar* fso_framework_utility_programName (void);
static void fso_framework_syslog_logger_finalize (GObject* obj);
#define FSO_FRAMEWORK_KMSG_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_KMSG_LOGGER, FsoFrameworkKmsgLoggerPrivate))
enum  {
	FSO_FRAMEWORK_KMSG_LOGGER_DUMMY_PROPERTY
};
static void fso_framework_kmsg_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message);
static gchar* fso_framework_kmsg_logger_real_format (FsoFrameworkAbstractLogger* base, const gchar* message, const gchar* level);
static void fso_framework_kmsg_logger_finalize (GObject* obj);
GType glib_logger_get_type (void) G_GNUC_CONST;
#define GLIB_LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GLIB_LOGGER, GLibLoggerPrivate))
enum  {
	GLIB_LOGGER_DUMMY_PROPERTY
};
GLibLogger* glib_logger_new (FsoFrameworkLogger* logger);
GLibLogger* glib_logger_construct (GType object_type, FsoFrameworkLogger* logger);
void glib_logger_log (GLibLogger* self, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
static void _glib_logger_log_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void glib_logger_finalize (GObject* obj);


void fso_framework_logger_setLevel (FsoFrameworkLogger* self, GLogLevelFlags level) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->setLevel (self, level);
}


void fso_framework_logger_setDestination (FsoFrameworkLogger* self, const gchar* destination) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->setDestination (self, destination);
}


void fso_framework_logger_setReprDelegate (FsoFrameworkLogger* self, ReprDelegate repr, void* repr_target) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->setReprDelegate (self, repr, repr_target);
}


GLogLevelFlags fso_framework_logger_getLevel (FsoFrameworkLogger* self) {
	g_return_val_if_fail (self != NULL, 0);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->getLevel (self);
}


gchar* fso_framework_logger_getDestination (FsoFrameworkLogger* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->getDestination (self);
}


gboolean fso_framework_logger_debug (FsoFrameworkLogger* self, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->debug (self, message);
}


gboolean fso_framework_logger_info (FsoFrameworkLogger* self, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->info (self, message);
}


gboolean fso_framework_logger_warning (FsoFrameworkLogger* self, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->warning (self, message);
}


gboolean fso_framework_logger_error (FsoFrameworkLogger* self, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->error (self, message);
}


gboolean fso_framework_logger_critical (FsoFrameworkLogger* self, const gchar* message) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->critical (self, message);
}


gboolean fso_framework_logger_data (FsoFrameworkLogger* self, guint8* message, int message_length1, gboolean in, GLogLevelFlags when) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FSO_FRAMEWORK_LOGGER_GET_INTERFACE (self)->data (self, message, message_length1, in, when);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FsoFrameworkLogger* fso_framework_logger_defaultLogger (void) {
	FsoFrameworkLogger* result = NULL;
	FsoFrameworkLogger* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	_tmp0_ = fso_framework_theLogger;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = fso_framework_theLogger;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


/**
     * @returns @a Logger
     **/
FsoFrameworkLogger* fso_framework_logger_createLogger (const gchar* group, const gchar* domain) {
	FsoFrameworkLogger* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FsoFrameworkLogger* _tmp4_ = NULL;
	FsoFrameworkLogger* _tmp5_;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = fso_framework_smart_key_file_defaultKeyFile ();
	_tmp1_ = _tmp0_;
	_tmp2_ = group;
	_tmp3_ = domain;
	_tmp4_ = fso_framework_logger_createFromKeyFile (_tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


/**
     * @returns @a Logger configured as requested in configuration file
     **/
FsoFrameworkLogger* fso_framework_logger_createFromConfig (const gchar* filename, const gchar* group, const gchar* domain) {
	FsoFrameworkLogger* result = NULL;
	const gchar* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_ = NULL;
	FsoFrameworkSmartKeyFile* smk;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FsoFrameworkLogger* _tmp4_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = fso_framework_smart_key_file_createFromConfig (_tmp0_);
	smk = _tmp1_;
	_tmp2_ = group;
	_tmp3_ = domain;
	_tmp4_ = fso_framework_logger_createFromKeyFile (smk, _tmp2_, _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (smk);
	return result;
}


/**
     * @returns @a Logger configured as requested in named key file
     **/
FsoFrameworkLogger* fso_framework_logger_createFromKeyFileName (const gchar* filename, const gchar* group, const gchar* domain) {
	FsoFrameworkLogger* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* smk;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FsoFrameworkLogger* _tmp4_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = fso_framework_smart_key_file_new ();
	smk = _tmp0_;
	_tmp1_ = filename;
	fso_framework_smart_key_file_loadFromFile (smk, _tmp1_);
	_tmp2_ = group;
	_tmp3_ = domain;
	_tmp4_ = fso_framework_logger_createFromKeyFile (smk, _tmp2_, _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (smk);
	return result;
}


/**
     * @returns a logger with data from @a FsoFramework.SmartKeyFile
     **/
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


FsoFrameworkLogger* fso_framework_logger_createFromKeyFile (FsoFrameworkSmartKeyFile* smk, const gchar* group, const gchar* domain) {
	FsoFrameworkLogger* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* log_level;
	const gchar* _tmp2_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* log_to;
	const gchar* _tmp8_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* log_destination;
	const gchar* _tmp14_;
	FsoFrameworkLogger* theLogger;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	static GQuark _tmp20_label2 = 0;
	static GQuark _tmp20_label3 = 0;
	static GQuark _tmp20_label4 = 0;
	static GQuark _tmp20_label5 = 0;
	FsoFrameworkLogger* _tmp58_;
	const gchar* _tmp59_;
	GLogLevelFlags _tmp60_ = 0;
	g_return_val_if_fail (smk != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = g_getenv (ENV_OVERRIDE_LOG_LEVEL);
	_tmp1_ = g_strdup (_tmp0_);
	log_level = _tmp1_;
	_tmp2_ = log_level;
	if (_tmp2_ == NULL) {
		FsoFrameworkSmartKeyFile* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = smk;
		_tmp4_ = group;
		_tmp5_ = fso_framework_smart_key_file_stringValue (_tmp3_, _tmp4_, "log_level", DEFAULT_LOG_LEVEL);
		_g_free0 (log_level);
		log_level = _tmp5_;
	}
	_tmp6_ = g_getenv (ENV_OVERRIDE_LOG_TO);
	_tmp7_ = g_strdup (_tmp6_);
	log_to = _tmp7_;
	_tmp8_ = log_to;
	if (_tmp8_ == NULL) {
		FsoFrameworkSmartKeyFile* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp9_ = smk;
		_tmp10_ = group;
		_tmp11_ = fso_framework_smart_key_file_stringValue (_tmp9_, _tmp10_, "log_to", DEFAULT_LOG_TYPE);
		_g_free0 (log_to);
		log_to = _tmp11_;
	}
	_tmp12_ = g_getenv (ENV_OVERRIDE_LOG_DESTINATION);
	_tmp13_ = g_strdup (_tmp12_);
	log_destination = _tmp13_;
	_tmp14_ = log_destination;
	if (_tmp14_ == NULL) {
		FsoFrameworkSmartKeyFile* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp15_ = smk;
		_tmp16_ = group;
		_tmp17_ = fso_framework_smart_key_file_stringValue (_tmp15_, _tmp16_, "log_destination", DEFAULT_LOG_DESTINATION);
		_g_free0 (log_destination);
		log_destination = _tmp17_;
	}
	theLogger = NULL;
	_tmp18_ = log_to;
	_tmp19_ = _tmp18_;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("stderr")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp22_;
				FsoFrameworkStdErrLogger* _tmp23_;
				FsoFrameworkStdErrLogger* logger;
				FsoFrameworkStdErrLogger* _tmp24_;
				FsoFrameworkLogger* _tmp25_;
				_tmp22_ = domain;
				_tmp23_ = fso_framework_std_err_logger_new (_tmp22_);
				logger = _tmp23_;
				_tmp24_ = logger;
				_tmp25_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp24_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp25_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("stderr:colors")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp26_;
				FsoFrameworkFileLogger* _tmp27_;
				FsoFrameworkFileLogger* logger;
				FsoFrameworkFileLogger* _tmp28_;
				FsoFrameworkFileLogger* _tmp29_;
				FsoFrameworkFileLogger* _tmp30_;
				FsoFrameworkLogger* _tmp31_;
				_tmp26_ = domain;
				_tmp27_ = fso_framework_file_logger_new (_tmp26_);
				logger = _tmp27_;
				_tmp28_ = logger;
				fso_framework_file_logger_setFile (_tmp28_, "stderr", TRUE);
				_tmp29_ = logger;
				fso_framework_abstract_logger_setColored ((FsoFrameworkAbstractLogger*) _tmp29_, TRUE);
				_tmp30_ = logger;
				_tmp31_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp30_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp31_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp32_;
				FsoFrameworkFileLogger* _tmp33_;
				FsoFrameworkFileLogger* logger;
				FsoFrameworkFileLogger* _tmp34_;
				const gchar* _tmp35_;
				FsoFrameworkFileLogger* _tmp36_;
				FsoFrameworkLogger* _tmp37_;
				_tmp32_ = domain;
				_tmp33_ = fso_framework_file_logger_new (_tmp32_);
				logger = _tmp33_;
				_tmp34_ = logger;
				_tmp35_ = log_destination;
				fso_framework_file_logger_setFile (_tmp34_, _tmp35_, TRUE);
				_tmp36_ = logger;
				_tmp37_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp36_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp37_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("syslog")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp38_;
				FsoFrameworkSyslogLogger* _tmp39_;
				FsoFrameworkSyslogLogger* logger;
				FsoFrameworkSyslogLogger* _tmp40_;
				FsoFrameworkLogger* _tmp41_;
				_tmp38_ = domain;
				_tmp39_ = fso_framework_syslog_logger_new (_tmp38_);
				logger = _tmp39_;
				_tmp40_ = logger;
				_tmp41_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp40_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp41_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("kmsg")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp42_;
				FsoFrameworkKmsgLogger* _tmp43_;
				FsoFrameworkKmsgLogger* logger;
				FsoFrameworkKmsgLogger* _tmp44_;
				FsoFrameworkLogger* _tmp45_;
				_tmp42_ = domain;
				_tmp43_ = fso_framework_kmsg_logger_new (_tmp42_);
				logger = _tmp43_;
				_tmp44_ = logger;
				_tmp45_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp44_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp45_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("none")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp46_;
				FsoFrameworkNullLogger* _tmp47_;
				FsoFrameworkNullLogger* logger;
				FsoFrameworkNullLogger* _tmp48_;
				FsoFrameworkLogger* _tmp49_;
				_tmp46_ = domain;
				_tmp47_ = fso_framework_null_logger_new (_tmp46_);
				logger = _tmp47_;
				_tmp48_ = logger;
				_tmp49_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp48_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp49_;
				_g_object_unref0 (logger);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp50_;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_;
				const gchar* _tmp54_;
				FsoFrameworkStdErrLogger* _tmp55_;
				FsoFrameworkStdErrLogger* logger;
				FsoFrameworkStdErrLogger* _tmp56_;
				FsoFrameworkLogger* _tmp57_;
				_tmp50_ = log_to;
				_tmp51_ = string_to_string (_tmp50_);
				_tmp52_ = g_strconcat ("Don't know how to instanciate logger type ", _tmp51_, ". Using StdErrLogger.", NULL);
				_tmp53_ = _tmp52_;
				g_warning ("logger.vala:146: %s", _tmp53_);
				_g_free0 (_tmp53_);
				_tmp54_ = domain;
				_tmp55_ = fso_framework_std_err_logger_new (_tmp54_);
				logger = _tmp55_;
				_tmp56_ = logger;
				_tmp57_ = _g_object_ref0 ((FsoFrameworkLogger*) _tmp56_);
				_g_object_unref0 (theLogger);
				theLogger = _tmp57_;
				_g_object_unref0 (logger);
				break;
			}
		}
	}
	_tmp58_ = theLogger;
	_tmp59_ = log_level;
	_tmp60_ = fso_framework_abstract_logger_stringToLevel (_tmp59_);
	fso_framework_logger_setLevel (_tmp58_, _tmp60_);
	result = theLogger;
	_g_free0 (log_destination);
	_g_free0 (log_to);
	_g_free0 (log_level);
	return result;
}


static void fso_framework_logger_base_init (FsoFrameworkLoggerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * @interface Logger
 */
GType fso_framework_logger_get_type (void) {
	static volatile gsize fso_framework_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkLoggerIface), (GBaseInitFunc) fso_framework_logger_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_framework_logger_type_id;
		fso_framework_logger_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoFrameworkLogger", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_framework_logger_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&fso_framework_logger_type_id__volatile, fso_framework_logger_type_id);
	}
	return fso_framework_logger_type_id__volatile;
}


static void fso_framework_abstract_logger_real_write (FsoFrameworkAbstractLogger* self, const gchar* message) {
	g_return_if_fail (message != NULL);
}


void fso_framework_abstract_logger_write (FsoFrameworkAbstractLogger* self, const gchar* message) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_ABSTRACT_LOGGER_GET_CLASS (self)->write (self, message);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gchar* fso_framework_abstract_logger_colorwrap (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* prefix;
	gchar* _tmp1_;
	gchar* postfix;
	const gchar* _tmp2_;
	gchar _tmp3_ = '\0';
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (level != NULL, NULL);
	_tmp0_ = g_strdup ("");
	prefix = _tmp0_;
	_tmp1_ = g_strdup ("\033[m");
	postfix = _tmp1_;
	_tmp2_ = level;
	_tmp3_ = string_get (_tmp2_, (glong) 1);
	switch (_tmp3_) {
		case 'D':
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("\033[1;30m");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case 'I':
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("\033[0;32m");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		case 'W':
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("\033[0;33m");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
		case 'E':
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("\033[0;31m");
			_g_free0 (prefix);
			prefix = _tmp7_;
			break;
		}
		case 'C':
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("\033[1;31m");
			_g_free0 (prefix);
			prefix = _tmp8_;
			break;
		}
		default:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = g_strdup ("");
			_g_free0 (prefix);
			prefix = _tmp9_;
			_tmp10_ = g_strdup ("");
			_g_free0 (postfix);
			postfix = _tmp10_;
			break;
		}
	}
	_tmp11_ = prefix;
	_tmp12_ = message;
	_tmp13_ = postfix;
	_tmp14_ = g_strdup_printf ("%s%s%s", _tmp11_, _tmp12_, _tmp13_);
	result = _tmp14_;
	_g_free0 (postfix);
	_g_free0 (prefix);
	return result;
}


static gchar* fso_framework_abstract_logger_real_format (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level) {
	gchar* result = NULL;
	GTimeVal t = {0};
	gchar* _tmp0_ = NULL;
	ReprDelegate _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* repr;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* str;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (level != NULL, NULL);
	g_get_current_time (&t);
	_tmp1_ = self->reprdelegate;
	_tmp1__target = self->reprdelegate_target;
	if (_tmp1_ != NULL) {
		ReprDelegate _tmp2_;
		void* _tmp2__target;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->reprdelegate;
		_tmp2__target = self->reprdelegate_target;
		_tmp3_ = _tmp2_ (_tmp2__target);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp6_ = g_strdup (_tmp5_);
	repr = _tmp6_;
	_tmp7_ = g_time_val_to_iso8601 (&t);
	_tmp8_ = _tmp7_;
	_tmp9_ = level;
	_tmp10_ = self->domain;
	_tmp11_ = repr;
	_tmp12_ = message;
	_tmp13_ = g_strdup_printf ("%s %s %s %s: %s\n", _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp8_);
	str = _tmp14_;
	_tmp16_ = self->colored;
	if (_tmp16_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		_tmp17_ = str;
		_tmp18_ = level;
		_tmp19_ = fso_framework_abstract_logger_colorwrap (self, _tmp17_, _tmp18_);
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp19_;
	} else {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = str;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp21_;
	}
	result = _tmp15_;
	_g_free0 (str);
	_g_free0 (repr);
	_g_free0 (_tmp0_);
	return result;
}


gchar* fso_framework_abstract_logger_format (FsoFrameworkAbstractLogger* self, const gchar* message, const gchar* level) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_ABSTRACT_LOGGER_GET_CLASS (self)->format (self, message, level);
}


FsoFrameworkAbstractLogger* fso_framework_abstract_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkAbstractLogger * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (domain != NULL, NULL);
	self = (FsoFrameworkAbstractLogger*) g_object_new (object_type, NULL);
	_tmp0_ = domain;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->domain);
	self->domain = _tmp1_;
	return self;
}


static void fso_framework_abstract_logger_real_setLevel (FsoFrameworkLogger* base, GLogLevelFlags level) {
	FsoFrameworkAbstractLogger * self;
	GLogLevelFlags _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	_tmp0_ = level;
	self->level = (guint) _tmp0_;
}


static GLogLevelFlags fso_framework_abstract_logger_real_getLevel (FsoFrameworkLogger* base) {
	FsoFrameworkAbstractLogger * self;
	GLogLevelFlags result = 0;
	guint _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	_tmp0_ = self->level;
	result = (GLogLevelFlags) _tmp0_;
	return result;
}


static void fso_framework_abstract_logger_real_setDestination (FsoFrameworkLogger* base, const gchar* destination) {
	FsoFrameworkAbstractLogger * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_if_fail (destination != NULL);
	_tmp0_ = destination;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->destination);
	self->destination = _tmp1_;
}


static gchar* fso_framework_abstract_logger_real_getDestination (FsoFrameworkLogger* base) {
	FsoFrameworkAbstractLogger * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FsoFrameworkAbstractLogger*) base;
	_tmp0_ = self->destination;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void fso_framework_abstract_logger_setColored (FsoFrameworkAbstractLogger* self, gboolean on) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = on;
	self->colored = _tmp0_;
}


gboolean fso_framework_abstract_logger_getColored (FsoFrameworkAbstractLogger* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->colored;
	result = _tmp0_;
	return result;
}


static void fso_framework_abstract_logger_real_setReprDelegate (FsoFrameworkLogger* base, ReprDelegate d, void* d_target) {
	FsoFrameworkAbstractLogger * self;
	ReprDelegate _tmp0_;
	void* _tmp0__target;
	self = (FsoFrameworkAbstractLogger*) base;
	_tmp0_ = d;
	_tmp0__target = d_target;
	(self->reprdelegate_target_destroy_notify == NULL) ? NULL : (self->reprdelegate_target_destroy_notify (self->reprdelegate_target), NULL);
	self->reprdelegate = NULL;
	self->reprdelegate_target = NULL;
	self->reprdelegate_target_destroy_notify = NULL;
	self->reprdelegate = _tmp0_;
	self->reprdelegate_target = _tmp0__target;
	self->reprdelegate_target_destroy_notify = NULL;
}


static gboolean fso_framework_abstract_logger_real_debug (FsoFrameworkLogger* base, const gchar* message) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	guint _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->level;
	if (_tmp0_ >= ((guint) G_LOG_LEVEL_DEBUG)) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = message;
		_tmp2_ = fso_framework_abstract_logger_format (self, _tmp1_, "[DEBUG]");
		_tmp3_ = _tmp2_;
		fso_framework_abstract_logger_write (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	result = TRUE;
	return result;
}


static gboolean fso_framework_abstract_logger_real_info (FsoFrameworkLogger* base, const gchar* message) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	guint _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->level;
	if (_tmp0_ >= ((guint) G_LOG_LEVEL_INFO)) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = message;
		_tmp2_ = fso_framework_abstract_logger_format (self, _tmp1_, "[INFO] ");
		_tmp3_ = _tmp2_;
		fso_framework_abstract_logger_write (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	result = TRUE;
	return result;
}


static gboolean fso_framework_abstract_logger_real_warning (FsoFrameworkLogger* base, const gchar* message) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	guint _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->level;
	if (_tmp0_ >= ((guint) G_LOG_LEVEL_WARNING)) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = message;
		_tmp2_ = fso_framework_abstract_logger_format (self, _tmp1_, "[WARN] ");
		_tmp3_ = _tmp2_;
		fso_framework_abstract_logger_write (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	result = TRUE;
	return result;
}


static gboolean fso_framework_abstract_logger_real_error (FsoFrameworkLogger* base, const gchar* message) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	guint _tmp0_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->level;
	if (_tmp0_ >= ((guint) G_LOG_LEVEL_ERROR)) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = message;
		_tmp2_ = fso_framework_abstract_logger_format (self, _tmp1_, "[ERROR]");
		_tmp3_ = _tmp2_;
		fso_framework_abstract_logger_write (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	result = TRUE;
	return result;
}


static gboolean fso_framework_abstract_logger_real_critical (FsoFrameworkLogger* base, const gchar* message) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	self = (FsoFrameworkAbstractLogger*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = fso_framework_abstract_logger_format (self, _tmp0_, "[CRITICAL]");
	_tmp2_ = _tmp1_;
	fso_framework_abstract_logger_write (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = stderr;
	_tmp4_ = message;
	_tmp5_ = g_strdup_printf ("Aborting due to critical error:\n'%s'\n", _tmp4_);
	_tmp6_ = _tmp5_;
	fprintf (_tmp3_, "%s", _tmp6_);
	_g_free0 (_tmp6_);
	exit (EXIT_FAILURE);
	result = TRUE;
	return result;
}


static gboolean fso_framework_abstract_logger_real_data (FsoFrameworkLogger* base, guint8* message, int message_length1, gboolean in, GLogLevelFlags when) {
	FsoFrameworkAbstractLogger * self;
	gboolean result = FALSE;
	guint _tmp0_;
	GLogLevelFlags _tmp1_;
	self = (FsoFrameworkAbstractLogger*) base;
	_tmp0_ = self->level;
	_tmp1_ = when;
	if (_tmp0_ >= ((guint) _tmp1_)) {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* direction;
		GLogLevelFlags _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* prefix;
		GString* _tmp14_;
		GString* hex;
		GString* _tmp15_;
		GString* readable;
		gint i;
		gint _tmp48_;
		_tmp3_ = in;
		if (_tmp3_) {
			_tmp2_ = ">>>";
		} else {
			_tmp2_ = "<<<";
		}
		_tmp4_ = _tmp2_;
		_tmp5_ = g_strdup (_tmp4_);
		direction = _tmp5_;
		_tmp6_ = when;
		_tmp7_ = fso_framework_abstract_logger_levelToString (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = direction;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("[", _tmp9_, "] ", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp8_);
		prefix = _tmp13_;
		_tmp14_ = g_string_new ("");
		hex = _tmp14_;
		_tmp15_ = g_string_new ("");
		readable = _tmp15_;
		i = 0;
		{
			gboolean _tmp16_;
			i = 0;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				guint8* _tmp20_;
				gint _tmp20__length1;
				guint8* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				guint8 _tmp23_;
				gboolean _tmp24_ = FALSE;
				GString* _tmp30_;
				guint8* _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				guint8 _tmp33_;
				gint _tmp34_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = message;
				_tmp20__length1 = message_length1;
				if (!(_tmp19_ < _tmp20__length1)) {
					break;
				}
				_tmp21_ = message;
				_tmp21__length1 = message_length1;
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = g_ascii_isprint ((gchar) _tmp23_);
				if (_tmp24_) {
					GString* _tmp25_;
					guint8* _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					guint8 _tmp28_;
					_tmp25_ = hex;
					_tmp26_ = message;
					_tmp26__length1 = message_length1;
					_tmp27_ = i;
					_tmp28_ = _tmp26_[_tmp27_];
					g_string_append_c (_tmp25_, (gchar) _tmp28_);
				} else {
					GString* _tmp29_;
					_tmp29_ = hex;
					g_string_append_c (_tmp29_, '.');
				}
				_tmp30_ = readable;
				_tmp31_ = message;
				_tmp31__length1 = message_length1;
				_tmp32_ = i;
				_tmp33_ = _tmp31_[_tmp32_];
				g_string_append_printf (_tmp30_, "%02X ", (guint) _tmp33_);
				_tmp34_ = i;
				if ((_tmp34_ % 16) == 15) {
					GString* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					GString* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_;
					GString* _tmp46_;
					GString* _tmp47_;
					_tmp35_ = readable;
					_tmp36_ = _tmp35_->str;
					_tmp37_ = g_strconcat (_tmp36_, " | ", NULL);
					_tmp38_ = _tmp37_;
					_tmp39_ = hex;
					_tmp40_ = _tmp39_->str;
					_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					_tmp43_ = prefix;
					_tmp44_ = fso_framework_abstract_logger_format (self, _tmp42_, _tmp43_);
					_tmp45_ = _tmp44_;
					fso_framework_abstract_logger_write (self, _tmp45_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp38_);
					_tmp46_ = g_string_new ("");
					_g_string_free0 (hex);
					hex = _tmp46_;
					_tmp47_ = g_string_new ("");
					_g_string_free0 (readable);
					readable = _tmp47_;
				}
			}
		}
		_tmp48_ = i;
		if ((_tmp48_ % 16) != 0) {
			GString* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			GString* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_ = NULL;
			gchar* _tmp65_;
			{
				gint _tmp49_;
				gboolean _tmp50_;
				_tmp49_ = i;
				i = _tmp49_ % 16;
				_tmp50_ = TRUE;
				while (TRUE) {
					gboolean _tmp51_;
					gint _tmp53_;
					GString* _tmp54_;
					_tmp51_ = _tmp50_;
					if (!_tmp51_) {
						gint _tmp52_;
						_tmp52_ = i;
						i = _tmp52_ + 1;
					}
					_tmp50_ = FALSE;
					_tmp53_ = i;
					if (!(_tmp53_ < 16)) {
						break;
					}
					_tmp54_ = readable;
					g_string_append (_tmp54_, "   ");
				}
			}
			_tmp55_ = readable;
			_tmp56_ = _tmp55_->str;
			_tmp57_ = g_strconcat (_tmp56_, " | ", NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = hex;
			_tmp60_ = _tmp59_->str;
			_tmp61_ = g_strconcat (_tmp58_, _tmp60_, NULL);
			_tmp62_ = _tmp61_;
			_tmp63_ = prefix;
			_tmp64_ = fso_framework_abstract_logger_format (self, _tmp62_, _tmp63_);
			_tmp65_ = _tmp64_;
			fso_framework_abstract_logger_write (self, _tmp65_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp62_);
			_g_free0 (_tmp58_);
		}
		_g_string_free0 (readable);
		_g_string_free0 (hex);
		_g_free0 (prefix);
		_g_free0 (direction);
	}
	result = TRUE;
	return result;
}


gchar* fso_framework_abstract_logger_levelToString (GLogLevelFlags level) {
	gchar* result = NULL;
	GLogLevelFlags _tmp0_;
	_tmp0_ = level;
	switch (_tmp0_) {
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("DEBUG");
			result = _tmp1_;
			return result;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("INFO");
			result = _tmp2_;
			return result;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("WARNING");
			result = _tmp3_;
			return result;
		}
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ERROR");
			result = _tmp4_;
			return result;
		}
		default:
		{
			GLogLevelFlags _tmp5_;
			_tmp5_ = level;
			g_error ("logger.vala:340: logger: unknown log level value %d", (gint) _tmp5_);
		}
	}
}


GLogLevelFlags fso_framework_abstract_logger_stringToLevel (const gchar* level) {
	GLogLevelFlags result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (level != NULL, 0);
	_tmp0_ = level;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("debug")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("DEBUG"))))) {
		switch (0) {
			default:
			{
				result = G_LOG_LEVEL_DEBUG;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("info")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("INFO"))))) {
		switch (0) {
			default:
			{
				result = G_LOG_LEVEL_INFO;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("warning")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("WARNING"))))) {
		switch (0) {
			default:
			{
				result = G_LOG_LEVEL_WARNING;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("error")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("ERROR"))))) {
		switch (0) {
			default:
			{
				result = G_LOG_LEVEL_ERROR;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_message ("logger.vala:361: Loglevel not defined, reverting to INFO\n");
				break;
			}
		}
	}
	result = G_LOG_LEVEL_INFO;
	return result;
}


static void fso_framework_abstract_logger_class_init (FsoFrameworkAbstractLoggerClass * klass) {
	fso_framework_abstract_logger_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->write = fso_framework_abstract_logger_real_write;
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->format = fso_framework_abstract_logger_real_format;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_abstract_logger_finalize;
}


static void fso_framework_abstract_logger_fso_framework_logger_interface_init (FsoFrameworkLoggerIface * iface) {
	fso_framework_abstract_logger_fso_framework_logger_parent_iface = g_type_interface_peek_parent (iface);
	iface->setLevel = (void (*)(FsoFrameworkLogger*, GLogLevelFlags)) fso_framework_abstract_logger_real_setLevel;
	iface->getLevel = (GLogLevelFlags (*)(FsoFrameworkLogger*)) fso_framework_abstract_logger_real_getLevel;
	iface->setDestination = (void (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_setDestination;
	iface->getDestination = (gchar* (*)(FsoFrameworkLogger*)) fso_framework_abstract_logger_real_getDestination;
	iface->setReprDelegate = (void (*)(FsoFrameworkLogger*, ReprDelegate, void*)) fso_framework_abstract_logger_real_setReprDelegate;
	iface->debug = (gboolean (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_debug;
	iface->info = (gboolean (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_info;
	iface->warning = (gboolean (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_warning;
	iface->error = (gboolean (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_error;
	iface->critical = (gboolean (*)(FsoFrameworkLogger*, const gchar*)) fso_framework_abstract_logger_real_critical;
	iface->data = (gboolean (*)(FsoFrameworkLogger*, guint8*, int, gboolean, GLogLevelFlags)) fso_framework_abstract_logger_real_data;
}


static void fso_framework_abstract_logger_instance_init (FsoFrameworkAbstractLogger * self) {
	self->level = (guint) G_LOG_LEVEL_INFO;
}


static void fso_framework_abstract_logger_finalize (GObject* obj) {
	FsoFrameworkAbstractLogger * self;
	self = FSO_FRAMEWORK_ABSTRACT_LOGGER (obj);
	_g_free0 (self->domain);
	_g_free0 (self->destination);
	(self->reprdelegate_target_destroy_notify == NULL) ? NULL : (self->reprdelegate_target_destroy_notify (self->reprdelegate_target), NULL);
	self->reprdelegate = NULL;
	self->reprdelegate_target = NULL;
	self->reprdelegate_target_destroy_notify = NULL;
	G_OBJECT_CLASS (fso_framework_abstract_logger_parent_class)->finalize (obj);
}


/**
 * @class AbstractLogger
 */
GType fso_framework_abstract_logger_get_type (void) {
	static volatile gsize fso_framework_abstract_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_abstract_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkAbstractLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_abstract_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkAbstractLogger), 0, (GInstanceInitFunc) fso_framework_abstract_logger_instance_init, NULL };
		static const GInterfaceInfo fso_framework_logger_info = { (GInterfaceInitFunc) fso_framework_abstract_logger_fso_framework_logger_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_framework_abstract_logger_type_id;
		fso_framework_abstract_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkAbstractLogger", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (fso_framework_abstract_logger_type_id, FSO_FRAMEWORK_TYPE_LOGGER, &fso_framework_logger_info);
		g_once_init_leave (&fso_framework_abstract_logger_type_id__volatile, fso_framework_abstract_logger_type_id);
	}
	return fso_framework_abstract_logger_type_id__volatile;
}


FsoFrameworkNullLogger* fso_framework_null_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkNullLogger * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	self = (FsoFrameworkNullLogger*) fso_framework_abstract_logger_construct (object_type, _tmp0_);
	return self;
}


FsoFrameworkNullLogger* fso_framework_null_logger_new (const gchar* domain) {
	return fso_framework_null_logger_construct (FSO_FRAMEWORK_TYPE_NULL_LOGGER, domain);
}


static void fso_framework_null_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message) {
	FsoFrameworkNullLogger * self;
	self = (FsoFrameworkNullLogger*) base;
	g_return_if_fail (message != NULL);
}


static void fso_framework_null_logger_class_init (FsoFrameworkNullLoggerClass * klass) {
	fso_framework_null_logger_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->write = fso_framework_null_logger_real_write;
}


static void fso_framework_null_logger_instance_init (FsoFrameworkNullLogger * self) {
}


/**
 * @class NullLogger
 */
GType fso_framework_null_logger_get_type (void) {
	static volatile gsize fso_framework_null_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_null_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkNullLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_null_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkNullLogger), 0, (GInstanceInitFunc) fso_framework_null_logger_instance_init, NULL };
		GType fso_framework_null_logger_type_id;
		fso_framework_null_logger_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, "FsoFrameworkNullLogger", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_null_logger_type_id__volatile, fso_framework_null_logger_type_id);
	}
	return fso_framework_null_logger_type_id__volatile;
}


static void fso_framework_file_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message) {
	FsoFrameworkFileLogger * self;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = (FsoFrameworkFileLogger*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->file;
	g_assert (_tmp0_ != (-1));
	_tmp1_ = self->priv->file;
	_tmp2_ = message;
	_tmp3_ = message;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	write (_tmp1_, _tmp2_, (gsize) _tmp5_);
}


FsoFrameworkFileLogger* fso_framework_file_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkFileLogger * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	self = (FsoFrameworkFileLogger*) fso_framework_abstract_logger_construct (object_type, _tmp0_);
	return self;
}


FsoFrameworkFileLogger* fso_framework_file_logger_new (const gchar* domain) {
	return fso_framework_file_logger_construct (FSO_FRAMEWORK_TYPE_FILE_LOGGER, domain);
}


void fso_framework_file_logger_setFile (FsoFrameworkFileLogger* self, const gchar* filename, gboolean append) {
	gint _tmp0_;
	const gchar* _tmp2_;
	gint _tmp11_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->file;
	if (_tmp0_ != (-1)) {
		gint _tmp1_;
		_g_free0 (((FsoFrameworkAbstractLogger*) self)->destination);
		((FsoFrameworkAbstractLogger*) self)->destination = NULL;
		_tmp1_ = self->priv->file;
		close (_tmp1_);
	}
	_tmp2_ = filename;
	if (g_strcmp0 (_tmp2_, "stderr") == 0) {
		FILE* _tmp3_;
		gint _tmp4_ = 0;
		_tmp3_ = stderr;
		_tmp4_ = fileno (_tmp3_);
		self->priv->file = _tmp4_;
	} else {
		gint _tmp5_ = 0;
		gboolean _tmp6_;
		gint _tmp7_;
		gint flags;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		_tmp6_ = append;
		if (_tmp6_) {
			_tmp5_ = O_APPEND | O_CREAT;
		} else {
			_tmp5_ = O_CREAT;
		}
		_tmp7_ = _tmp5_;
		flags = O_WRONLY | _tmp7_;
		_tmp8_ = filename;
		_tmp9_ = flags;
		_tmp10_ = open (_tmp8_, _tmp9_, ((S_IRUSR | S_IWUSR) | S_IRGRP) | S_IROTH);
		self->priv->file = _tmp10_;
	}
	_tmp11_ = self->priv->file;
	if (_tmp11_ == (-1)) {
		const gchar* _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_ = NULL;
		_tmp12_ = filename;
		_tmp13_ = errno;
		_tmp14_ = strerror (_tmp13_);
		g_error ("logger.vala:419: %s: %s", _tmp12_, _tmp14_);
	}
	_tmp15_ = filename;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (((FsoFrameworkAbstractLogger*) self)->destination);
	((FsoFrameworkAbstractLogger*) self)->destination = _tmp16_;
}


static void fso_framework_file_logger_class_init (FsoFrameworkFileLoggerClass * klass) {
	fso_framework_file_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkFileLoggerPrivate));
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->write = fso_framework_file_logger_real_write;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_file_logger_finalize;
}


static void fso_framework_file_logger_instance_init (FsoFrameworkFileLogger * self) {
	self->priv = FSO_FRAMEWORK_FILE_LOGGER_GET_PRIVATE (self);
	self->priv->file = -1;
}


static void fso_framework_file_logger_finalize (GObject* obj) {
	FsoFrameworkFileLogger * self;
	self = FSO_FRAMEWORK_FILE_LOGGER (obj);
	G_OBJECT_CLASS (fso_framework_file_logger_parent_class)->finalize (obj);
}


/**
 * @class FileLogger
 */
GType fso_framework_file_logger_get_type (void) {
	static volatile gsize fso_framework_file_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_file_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkFileLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_file_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkFileLogger), 0, (GInstanceInitFunc) fso_framework_file_logger_instance_init, NULL };
		GType fso_framework_file_logger_type_id;
		fso_framework_file_logger_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, "FsoFrameworkFileLogger", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_file_logger_type_id__volatile, fso_framework_file_logger_type_id);
	}
	return fso_framework_file_logger_type_id__volatile;
}


FsoFrameworkStdErrLogger* fso_framework_std_err_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkStdErrLogger * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	self = (FsoFrameworkStdErrLogger*) fso_framework_file_logger_construct (object_type, _tmp0_);
	fso_framework_file_logger_setFile ((FsoFrameworkFileLogger*) self, "stderr", TRUE);
	return self;
}


FsoFrameworkStdErrLogger* fso_framework_std_err_logger_new (const gchar* domain) {
	return fso_framework_std_err_logger_construct (FSO_FRAMEWORK_TYPE_STD_ERR_LOGGER, domain);
}


static void fso_framework_std_err_logger_class_init (FsoFrameworkStdErrLoggerClass * klass) {
	fso_framework_std_err_logger_parent_class = g_type_class_peek_parent (klass);
}


static void fso_framework_std_err_logger_instance_init (FsoFrameworkStdErrLogger * self) {
}


/**
 * @class StdErrLogger
 */
GType fso_framework_std_err_logger_get_type (void) {
	static volatile gsize fso_framework_std_err_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_std_err_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkStdErrLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_std_err_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkStdErrLogger), 0, (GInstanceInitFunc) fso_framework_std_err_logger_instance_init, NULL };
		GType fso_framework_std_err_logger_type_id;
		fso_framework_std_err_logger_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_FILE_LOGGER, "FsoFrameworkStdErrLogger", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_std_err_logger_type_id__volatile, fso_framework_std_err_logger_type_id);
	}
	return fso_framework_std_err_logger_type_id__volatile;
}


static void fso_framework_syslog_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message) {
	FsoFrameworkSyslogLogger * self;
	const gchar* _tmp0_;
	self = (FsoFrameworkSyslogLogger*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	syslog (LOG_DEBUG, "%s", _tmp0_, NULL);
}


/**
     * Overridden, since syslog already includes a timestamp
     **/
static gchar* fso_framework_syslog_logger_real_format (FsoFrameworkAbstractLogger* base, const gchar* message, const gchar* level) {
	FsoFrameworkSyslogLogger * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	ReprDelegate _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* repr;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* str;
	self = (FsoFrameworkSyslogLogger*) base;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (level != NULL, NULL);
	_tmp1_ = ((FsoFrameworkAbstractLogger*) self)->reprdelegate;
	_tmp1__target = ((FsoFrameworkAbstractLogger*) self)->reprdelegate_target;
	if (_tmp1_ != NULL) {
		ReprDelegate _tmp2_;
		void* _tmp2__target;
		gchar* _tmp3_ = NULL;
		_tmp2_ = ((FsoFrameworkAbstractLogger*) self)->reprdelegate;
		_tmp2__target = ((FsoFrameworkAbstractLogger*) self)->reprdelegate_target;
		_tmp3_ = _tmp2_ (_tmp2__target);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp6_ = g_strdup (_tmp5_);
	repr = _tmp6_;
	_tmp7_ = level;
	_tmp8_ = ((FsoFrameworkAbstractLogger*) self)->domain;
	_tmp9_ = message;
	_tmp10_ = g_strdup_printf ("%s %s %s: %s\n", _tmp7_, _tmp8_, repr, _tmp9_);
	str = _tmp10_;
	result = str;
	_g_free0 (repr);
	_g_free0 (_tmp0_);
	return result;
}


FsoFrameworkSyslogLogger* fso_framework_syslog_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkSyslogLogger * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	self = (FsoFrameworkSyslogLogger*) fso_framework_abstract_logger_construct (object_type, _tmp0_);
	_tmp1_ = fso_framework_syslog_logger_basename;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = fso_framework_utility_programName ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%s", _tmp3_);
		_g_free0 (fso_framework_syslog_logger_basename);
		fso_framework_syslog_logger_basename = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = fso_framework_syslog_logger_basename;
	openlog (_tmp5_, LOG_PID | LOG_CONS, LOG_DAEMON);
	return self;
}


FsoFrameworkSyslogLogger* fso_framework_syslog_logger_new (const gchar* domain) {
	return fso_framework_syslog_logger_construct (FSO_FRAMEWORK_TYPE_SYSLOG_LOGGER, domain);
}


static void fso_framework_syslog_logger_class_init (FsoFrameworkSyslogLoggerClass * klass) {
	fso_framework_syslog_logger_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->write = fso_framework_syslog_logger_real_write;
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->format = fso_framework_syslog_logger_real_format;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_syslog_logger_finalize;
}


static void fso_framework_syslog_logger_instance_init (FsoFrameworkSyslogLogger * self) {
}


static void fso_framework_syslog_logger_finalize (GObject* obj) {
	FsoFrameworkSyslogLogger * self;
	self = FSO_FRAMEWORK_SYSLOG_LOGGER (obj);
	G_OBJECT_CLASS (fso_framework_syslog_logger_parent_class)->finalize (obj);
}


/**
 * @class SyslogLogger
 */
GType fso_framework_syslog_logger_get_type (void) {
	static volatile gsize fso_framework_syslog_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_syslog_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkSyslogLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_syslog_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkSyslogLogger), 0, (GInstanceInitFunc) fso_framework_syslog_logger_instance_init, NULL };
		GType fso_framework_syslog_logger_type_id;
		fso_framework_syslog_logger_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, "FsoFrameworkSyslogLogger", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_syslog_logger_type_id__volatile, fso_framework_syslog_logger_type_id);
	}
	return fso_framework_syslog_logger_type_id__volatile;
}


static void fso_framework_kmsg_logger_real_write (FsoFrameworkAbstractLogger* base, const gchar* message) {
	FsoFrameworkKmsgLogger * self;
	gint _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (FsoFrameworkKmsgLogger*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->kmsg_fd;
	_tmp1_ = message;
	_tmp2_ = message;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	write (_tmp0_, _tmp1_, (gsize) _tmp4_);
}


static gchar* fso_framework_kmsg_logger_real_format (FsoFrameworkAbstractLogger* base, const gchar* message, const gchar* level) {
	FsoFrameworkKmsgLogger * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	ReprDelegate _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* repr;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* str;
	self = (FsoFrameworkKmsgLogger*) base;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (level != NULL, NULL);
	_tmp1_ = ((FsoFrameworkAbstractLogger*) self)->reprdelegate;
	_tmp1__target = ((FsoFrameworkAbstractLogger*) self)->reprdelegate_target;
	if (_tmp1_ != NULL) {
		ReprDelegate _tmp2_;
		void* _tmp2__target;
		gchar* _tmp3_ = NULL;
		_tmp2_ = ((FsoFrameworkAbstractLogger*) self)->reprdelegate;
		_tmp2__target = ((FsoFrameworkAbstractLogger*) self)->reprdelegate_target;
		_tmp3_ = _tmp2_ (_tmp2__target);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp6_ = g_strdup (_tmp5_);
	repr = _tmp6_;
	_tmp7_ = level;
	_tmp8_ = ((FsoFrameworkAbstractLogger*) self)->domain;
	_tmp9_ = message;
	_tmp10_ = g_strdup_printf ("%s %s %s: %s\n", _tmp7_, _tmp8_, repr, _tmp9_);
	str = _tmp10_;
	result = str;
	_g_free0 (repr);
	_g_free0 (_tmp0_);
	return result;
}


FsoFrameworkKmsgLogger* fso_framework_kmsg_logger_construct (GType object_type, const gchar* domain) {
	FsoFrameworkKmsgLogger * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	self = (FsoFrameworkKmsgLogger*) fso_framework_abstract_logger_construct (object_type, _tmp0_);
	_tmp1_ = open ("/dev/kmsg", O_WRONLY | O_NOCTTY, (mode_t) 0);
	self->priv->kmsg_fd = _tmp1_;
	return self;
}


FsoFrameworkKmsgLogger* fso_framework_kmsg_logger_new (const gchar* domain) {
	return fso_framework_kmsg_logger_construct (FSO_FRAMEWORK_TYPE_KMSG_LOGGER, domain);
}


static void fso_framework_kmsg_logger_class_init (FsoFrameworkKmsgLoggerClass * klass) {
	fso_framework_kmsg_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkKmsgLoggerPrivate));
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->write = fso_framework_kmsg_logger_real_write;
	FSO_FRAMEWORK_ABSTRACT_LOGGER_CLASS (klass)->format = fso_framework_kmsg_logger_real_format;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_kmsg_logger_finalize;
}


static void fso_framework_kmsg_logger_instance_init (FsoFrameworkKmsgLogger * self) {
	self->priv = FSO_FRAMEWORK_KMSG_LOGGER_GET_PRIVATE (self);
}


static void fso_framework_kmsg_logger_finalize (GObject* obj) {
	FsoFrameworkKmsgLogger * self;
	self = FSO_FRAMEWORK_KMSG_LOGGER (obj);
	G_OBJECT_CLASS (fso_framework_kmsg_logger_parent_class)->finalize (obj);
}


/**
 * @class KmsgLogger
 */
GType fso_framework_kmsg_logger_get_type (void) {
	static volatile gsize fso_framework_kmsg_logger_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_kmsg_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkKmsgLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_kmsg_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkKmsgLogger), 0, (GInstanceInitFunc) fso_framework_kmsg_logger_instance_init, NULL };
		GType fso_framework_kmsg_logger_type_id;
		fso_framework_kmsg_logger_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_LOGGER, "FsoFrameworkKmsgLogger", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_kmsg_logger_type_id__volatile, fso_framework_kmsg_logger_type_id);
	}
	return fso_framework_kmsg_logger_type_id__volatile;
}


static void _glib_logger_log_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	glib_logger_log (self, log_domain, log_levels, message);
}


GLibLogger* glib_logger_construct (GType object_type, FsoFrameworkLogger* logger) {
	GLibLogger * self = NULL;
	FsoFrameworkLogger* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	g_return_val_if_fail (logger != NULL, NULL);
	self = (GLibLogger*) g_object_new (object_type, NULL);
	_tmp0_ = logger;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->logger);
	self->priv->logger = _tmp1_;
	g_log_set_handler ("GLib", (G_LOG_LEVEL_MASK | G_LOG_FLAG_RECURSION) | G_LOG_FLAG_FATAL, _glib_logger_log_glog_func, self);
	g_log_set_default_handler (_glib_logger_log_glog_func, self);
	return self;
}


GLibLogger* glib_logger_new (FsoFrameworkLogger* logger) {
	return glib_logger_construct (TYPE_GLIB_LOGGER, logger);
}


void glib_logger_log (GLibLogger* self, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* str;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GLogLevelFlags _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp1_ = log_domain;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("GLib <>: ");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = log_domain;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("GLib <", _tmp4_, ">: ", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp7_ = g_strdup (_tmp6_);
	str = _tmp7_;
	_tmp8_ = str;
	_tmp9_ = message;
	_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
	_g_free0 (str);
	str = _tmp10_;
	_tmp11_ = log_level;
	switch (_tmp11_ & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			FsoFrameworkLogger* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = self->priv->logger;
			_tmp13_ = str;
			fso_framework_logger_error (_tmp12_, _tmp13_);
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			FsoFrameworkLogger* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = self->priv->logger;
			_tmp15_ = str;
			fso_framework_logger_critical (_tmp14_, _tmp15_);
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			FsoFrameworkLogger* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = self->priv->logger;
			_tmp17_ = str;
			fso_framework_logger_warning (_tmp16_, _tmp17_);
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		case G_LOG_LEVEL_INFO:
		{
			FsoFrameworkLogger* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = self->priv->logger;
			_tmp19_ = str;
			fso_framework_logger_info (_tmp18_, _tmp19_);
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			FsoFrameworkLogger* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = self->priv->logger;
			_tmp21_ = str;
			fso_framework_logger_debug (_tmp20_, _tmp21_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_free0 (str);
	_g_free0 (_tmp0_);
}


static void glib_logger_class_init (GLibLoggerClass * klass) {
	glib_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GLibLoggerPrivate));
	G_OBJECT_CLASS (klass)->finalize = glib_logger_finalize;
}


static void glib_logger_instance_init (GLibLogger * self) {
	self->priv = GLIB_LOGGER_GET_PRIVATE (self);
}


static void glib_logger_finalize (GObject* obj) {
	GLibLogger * self;
	self = GLIB_LOGGER (obj);
	_g_object_unref0 (self->priv->logger);
	G_OBJECT_CLASS (glib_logger_parent_class)->finalize (obj);
}


/**
 * @class GLibLogger
 */
GType glib_logger_get_type (void) {
	static volatile gsize glib_logger_type_id__volatile = 0;
	if (g_once_init_enter (&glib_logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GLibLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glib_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GLibLogger), 0, (GInstanceInitFunc) glib_logger_instance_init, NULL };
		GType glib_logger_type_id;
		glib_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "GLibLogger", &g_define_type_info, 0);
		g_once_init_leave (&glib_logger_type_id__volatile, glib_logger_type_id);
	}
	return glib_logger_type_id__volatile;
}



