/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"
void lt_set_config_err(char *option, char *val) {
	printf("Error: invalid value [%s] to option [%s] in cfg file\n", val, option);
	exit (1);
}

void lt_set_config(char *option, char *val) {
	if(strncmp(option, "time_format", 32) == 0) {
		if(strncmp(val, "long", 32) == 0) {
			timefmt = DATE_LONG;
		} else if(strncmp(val, "short", 32) == 0) {
			timefmt = DATE_SHORT;
		} else {
			lt_set_config_err(option, val);
		}
		
	} else if(strncmp(option, "show_source", 32) == 0) {
		if(strncmp(val, "true", 32) == 0) {
			showsrc = TRUE;
		} else if(strncmp(val, "false", 32) == 0) {
			showsrc = FALSE;
		} else {
			lt_set_config_err(option, val);
		}

	} else if(strncmp(option, "show_program", 32) == 0) {
		if(strncmp(val, "true", 32) == 0) {
			showprog = TRUE;
		} else if(strncmp(val, "false", 32) == 0) {
			showprog = FALSE;
		} else {
			lt_set_config_err(option, val);
		}

	} else if(strncmp(option, "verbose", 32) == 0) {
		if(strncmp(val, "true", 32) == 0) {
			verbose = TRUE;
		} else if(strncmp(val, "false", 32) == 0) {
			verbose = FALSE;
		} else {
			lt_set_config_err(option, val);
		}

	} else if(strncmp(option, "redbeep", 32) == 0) {
		if(strncmp(val, "true", 32) == 0) {
			redbeep = TRUE;
		} else if(strncmp(val, "false", 32) == 0) {
			redbeep = FALSE;
		} else {
			lt_set_config_err(option, val);
		}

	} else if(strncmp(option, "output_format", 32) == 0) {
		if(strncmp(val, "ansi", 32) == 0) {
			outfmt = OUTPUT_ANSI;
		} else if(strncmp(val, "ascii", 32) == 0) {
			outfmt = OUTPUT_ASCII;
		} else if(strncmp(val, "csv", 32) == 0) {
			outfmt = OUTPUT_CSV;
		} else if(strncmp(val, "html", 32) == 0) {
			outfmt = OUTPUT_HTML;
		} else if(strncmp(val, "raw", 32) == 0) {
			outfmt = OUTPUT_RAW;
		} else {
			lt_set_config_err(option, val);
		}	       
			
	} else if(strncmp(option, "includefile", 32) == 0) {
		if(val == "\0") {
			printf("Checks.include = FALSE");
			checks.include = FALSE;
		} else {
			strncpy(includefile, val, 256);
			checks.include = TRUE;
		}
	} else if(strncmp(option, "excludefile", 32) == 0) {
		if(val == "\0") {
			checks.exclude = FALSE;
		} else {
			strncpy(excludefile, val, 256);
			checks.exclude = TRUE;
		}
	} else if(strncmp(option, "greenfile", 32) == 0) {
		if(val == "\0") {
			checks.green = FALSE;
		} else {
			strncpy(greenfile, val, 256);
			checks.green = TRUE;
		}

	} else if(strncmp(option, "yellowfile", 32) == 0) {
		if(val == "\0") {
			checks.yellow = FALSE;
		} else {
			strncpy(yellowfile, val, 256);
			checks.yellow = TRUE;
		}

	} else {
		printf("Error: invalid option [%s]\n", option);
		exit (1);
	}
}

void lt_read_config() {
	char line[1024];
	char opt[256];
	char val[256];
	FILE *cfgfile;
	
	cfgfile = fopen(configfile, "r");
	if( ! cfgfile ) {
		perror(configfile);
		exit (1);
	}
	while(fgets(line, 1023, cfgfile) != NULL) {
		if(lt_match(line, ".*=.*") == TRUE) {
			strcpy(val, "\0");
			strcpy(opt, "\0");
			
			sscanf(line, "%[^=]", opt);
			sscanf(line, "%*[^=]=%s", val);
			lt_set_config(opt, val);
		}
	}
	fclose(cfgfile);
}

