%define name	icecast
%define version	1.3.12
%define release 1

Summary:	Icecast - Streaming Media Server
Name:		%{name}
Version:	%{version}
Release:	%{release}
Group:		Applications/Multimedia
Copyright:	GPL
URL:		http://www.icecast.org
Vendor:		Icecast <team@icecast.org>
Source:		%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root


%description
Icecast is an Internet based broadcasting system based on the Mpeg Layer III
streaming technology.  It was originally inspired by Nullsoft's Shoutcast
and also mp3serv by Scott Manley.  The icecast project was started for several
reasons: a) all broadcasting systems were pretty much closed source,
non-free software implementations, b) Shoutcast doesn't allow you to run your
own directory servers, or support them, and c) we thought it would be a
lot of fun.

%prep
%setup

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --enable-fsstd
else
  CFLAGS="$RPM_FLAGS" ./configure --enable-fsstd
./configure --enable-fsstd
fi
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# copy the configuration files to be the right name so that it works without 
# _having_ # to change them (though they should), and leave the defaults so 
# they don't screw with them
cp $RPM_BUILD_ROOT/etc/icecast/icecast.conf.dist $RPM_BUILD_ROOT/etc/icecast/icecast.conf
cp $RPM_BUILD_ROOT/etc/icecast/groups.aut.dist $RPM_BUILD_ROOT/etc/icecast/groups.aut
cp $RPM_BUILD_ROOT/etc/icecast/mounts.aut.dist $RPM_BUILD_ROOT/etc/icecast/mounts.aut
cp $RPM_BUILD_ROOT/etc/icecast/users.aut.dist $RPM_BUILD_ROOT/etc/icecast/users.aut

%files
%defattr(-,root,root)
%doc AUTHORS
%doc BUGS
%doc CHANGES
%doc COPYING
%doc FAQ
%doc README
%doc TESTED
%doc TODO
%doc doc/manual.html
/usr/sbin/icecast
/var/log/icecast
/usr/share/icecast/
/etc/icecast/groups.aut.dist
/etc/icecast/mounts.aut.dist
/etc/icecast/users.aut.dist
/etc/icecast/icecast.conf.dist
%config /etc/icecast/groups.aut
%config /etc/icecast/mounts.aut
%config /etc/icecast/users.aut
%config /etc/icecast/icecast.conf

%clean 
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post

%postun

%changelog
* Tue Mar 21 2000 Jeremy Katz <katzj@icecast.org>
- clean up the spec file a little

* Thu Dec 9 1999 Jeremy Katz <katzj@icecast.org>
- First official rpm build, using 2.0.0-beta










