/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGException.h"

#include "KURL.h"
#include "SVGException.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGException);

/* Hash table */

static const HashTableValue JSSVGExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGExceptionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGExceptionTableValues, 0 };
#else
    { 10, 7, JSSVGExceptionTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGExceptionConstructorTableValues[4] =
{
    { "SVG_WRONG_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_WRONG_TYPE_ERR, (intptr_t)0 },
    { "SVG_INVALID_VALUE_ERR", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_INVALID_VALUE_ERR, (intptr_t)0 },
    { "SVG_MATRIX_NOT_INVERTABLE", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_MATRIX_NOT_INVERTABLE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGExceptionConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGExceptionConstructorTableValues, 0 };
#else
    { 9, 7, JSSVGExceptionConstructorTableValues, 0 };
#endif

class JSSVGExceptionConstructor : public DOMConstructorObject {
public:
    JSSVGExceptionConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGExceptionConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGExceptionPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGExceptionConstructor::s_info = { "SVGExceptionConstructor", 0, &JSSVGExceptionConstructorTable, 0 };

bool JSSVGExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGExceptionConstructor, DOMObject>(exec, &JSSVGExceptionConstructorTable, this, propertyName, slot);
}

bool JSSVGExceptionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGExceptionConstructor, DOMObject>(exec, &JSSVGExceptionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGExceptionPrototypeTableValues[5] =
{
    { "SVG_WRONG_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_WRONG_TYPE_ERR, (intptr_t)0 },
    { "SVG_INVALID_VALUE_ERR", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_INVALID_VALUE_ERR, (intptr_t)0 },
    { "SVG_MATRIX_NOT_INVERTABLE", DontDelete|ReadOnly, (intptr_t)jsSVGExceptionSVG_MATRIX_NOT_INVERTABLE, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsSVGExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGExceptionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGExceptionPrototypeTableValues, 0 };
#else
    { 9, 7, JSSVGExceptionPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGExceptionPrototype::s_info = { "SVGExceptionPrototype", 0, &JSSVGExceptionPrototypeTable, 0 };

JSObject* JSSVGExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGException>(exec, globalObject);
}

bool JSSVGExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGExceptionPrototype, JSObject>(exec, &JSSVGExceptionPrototypeTable, this, propertyName, slot);
}

bool JSSVGExceptionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGExceptionPrototype, JSObject>(exec, &JSSVGExceptionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGException::s_info = { "SVGException", 0, &JSSVGExceptionTable, 0 };

JSSVGException::JSSVGException(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGException> impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGException::~JSSVGException()
{
    forgetDOMObject(this, impl());
}

JSObject* JSSVGException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGExceptionPrototype(JSSVGExceptionPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGException, Base>(exec, &JSSVGExceptionTable, this, propertyName, slot);
}

bool JSSVGException::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGException, Base>(exec, &JSSVGExceptionTable, this, propertyName, descriptor);
}

JSValue jsSVGExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGException* castedThis = static_cast<JSSVGException*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGException* imp = static_cast<SVGException*>(castedThis->impl());
    return jsNumber(exec, imp->code());
}

JSValue jsSVGExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGException* castedThis = static_cast<JSSVGException*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGException* imp = static_cast<SVGException*>(castedThis->impl());
    return jsString(exec, imp->name());
}

JSValue jsSVGExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGException* castedThis = static_cast<JSSVGException*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGException* imp = static_cast<SVGException*>(castedThis->impl());
    return jsString(exec, imp->message());
}

JSValue jsSVGExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UNUSED_PARAM(slot);
    return JSSVGException::getConstructor(exec, deprecatedGlobalObjectForPrototype(exec));
}
JSValue JSSVGException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGExceptionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGException::s_info))
        return throwError(exec, TypeError);
    JSSVGException* castedThisObj = static_cast<JSSVGException*>(asObject(thisValue));
    SVGException* imp = static_cast<SVGException*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue jsSVGExceptionSVG_WRONG_TYPE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGExceptionSVG_INVALID_VALUE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGExceptionSVG_MATRIX_NOT_INVERTABLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGException* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGException>(exec, globalObject, object, context);
}
SVGException* toSVGException(JSC::JSValue value)
{
    return value.inherits(&JSSVGException::s_info) ? static_cast<JSSVGException*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
