/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationEvent.h"

#include "JSNode.h"
#include "KURL.h"
#include "MutationEvent.h"
#include "Node.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMutationEvent);

/* Hash table */

static const HashTableValue JSMutationEventTableValues[7] =
{
    { "relatedNode", DontDelete|ReadOnly, (intptr_t)jsMutationEventRelatedNode, (intptr_t)0 },
    { "prevValue", DontDelete|ReadOnly, (intptr_t)jsMutationEventPrevValue, (intptr_t)0 },
    { "newValue", DontDelete|ReadOnly, (intptr_t)jsMutationEventNewValue, (intptr_t)0 },
    { "attrName", DontDelete|ReadOnly, (intptr_t)jsMutationEventAttrName, (intptr_t)0 },
    { "attrChange", DontDelete|ReadOnly, (intptr_t)jsMutationEventAttrChange, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMutationEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMutationEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSMutationEventTableValues, 0 };
#else
    { 17, 15, JSMutationEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMutationEventConstructorTableValues[4] =
{
    { "MODIFICATION", DontDelete|ReadOnly, (intptr_t)jsMutationEventMODIFICATION, (intptr_t)0 },
    { "ADDITION", DontDelete|ReadOnly, (intptr_t)jsMutationEventADDITION, (intptr_t)0 },
    { "REMOVAL", DontDelete|ReadOnly, (intptr_t)jsMutationEventREMOVAL, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMutationEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMutationEventConstructorTableValues, 0 };
#else
    { 8, 7, JSMutationEventConstructorTableValues, 0 };
#endif

class JSMutationEventConstructor : public DOMConstructorObject {
public:
    JSMutationEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSMutationEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSMutationEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMutationEventConstructor::s_info = { "MutationEventConstructor", 0, &JSMutationEventConstructorTable, 0 };

bool JSMutationEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMutationEventConstructor, DOMObject>(exec, &JSMutationEventConstructorTable, this, propertyName, slot);
}

bool JSMutationEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMutationEventConstructor, DOMObject>(exec, &JSMutationEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMutationEventPrototypeTableValues[5] =
{
    { "MODIFICATION", DontDelete|ReadOnly, (intptr_t)jsMutationEventMODIFICATION, (intptr_t)0 },
    { "ADDITION", DontDelete|ReadOnly, (intptr_t)jsMutationEventADDITION, (intptr_t)0 },
    { "REMOVAL", DontDelete|ReadOnly, (intptr_t)jsMutationEventREMOVAL, (intptr_t)0 },
    { "initMutationEvent", DontDelete|Function, (intptr_t)jsMutationEventPrototypeFunctionInitMutationEvent, (intptr_t)8 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMutationEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMutationEventPrototypeTableValues, 0 };
#else
    { 8, 7, JSMutationEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSMutationEventPrototype::s_info = { "MutationEventPrototype", 0, &JSMutationEventPrototypeTable, 0 };

JSObject* JSMutationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMutationEvent>(exec, globalObject);
}

bool JSMutationEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSMutationEventPrototype, JSObject>(exec, &JSMutationEventPrototypeTable, this, propertyName, slot);
}

bool JSMutationEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSMutationEventPrototype, JSObject>(exec, &JSMutationEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSMutationEvent::s_info = { "MutationEvent", &JSEvent::s_info, &JSMutationEventTable, 0 };

JSMutationEvent::JSMutationEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<MutationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSMutationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMutationEventPrototype(JSMutationEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSMutationEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMutationEvent, Base>(exec, &JSMutationEventTable, this, propertyName, slot);
}

bool JSMutationEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMutationEvent, Base>(exec, &JSMutationEventTable, this, propertyName, descriptor);
}

JSValue jsMutationEventRelatedNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* castedThis = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MutationEvent* imp = static_cast<MutationEvent*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->relatedNode()));
}

JSValue jsMutationEventPrevValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* castedThis = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MutationEvent* imp = static_cast<MutationEvent*>(castedThis->impl());
    return jsString(exec, imp->prevValue());
}

JSValue jsMutationEventNewValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* castedThis = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MutationEvent* imp = static_cast<MutationEvent*>(castedThis->impl());
    return jsString(exec, imp->newValue());
}

JSValue jsMutationEventAttrName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* castedThis = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MutationEvent* imp = static_cast<MutationEvent*>(castedThis->impl());
    return jsString(exec, imp->attrName());
}

JSValue jsMutationEventAttrChange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* castedThis = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MutationEvent* imp = static_cast<MutationEvent*>(castedThis->impl());
    return jsNumber(exec, imp->attrChange());
}

JSValue jsMutationEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMutationEvent* domObject = static_cast<JSMutationEvent*>(asObject(slot.slotBase()));
    return JSMutationEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSMutationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsMutationEventPrototypeFunctionInitMutationEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSMutationEvent::s_info))
        return throwError(exec, TypeError);
    JSMutationEvent* castedThisObj = static_cast<JSMutationEvent*>(asObject(thisValue));
    MutationEvent* imp = static_cast<MutationEvent*>(castedThisObj->impl());
    const UString& type = args.at(0).toString(exec);
    bool canBubble = args.at(1).toBoolean(exec);
    bool cancelable = args.at(2).toBoolean(exec);
    Node* relatedNode = toNode(args.at(3));
    const UString& prevValue = args.at(4).toString(exec);
    const UString& newValue = args.at(5).toString(exec);
    const UString& attrName = args.at(6).toString(exec);
    unsigned short attrChange = args.at(7).toInt32(exec);

    imp->initMutationEvent(type, canBubble, cancelable, relatedNode, prevValue, newValue, attrName, attrChange);
    return jsUndefined();
}

// Constant getters

JSValue jsMutationEventMODIFICATION(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsMutationEventADDITION(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsMutationEventREMOVAL(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}


}
