#!/bin/sh
# CVE-2011-2979
# CVE-2011-2380
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

Description: CVE-2011-2979/2380  Group Information Leak
Origin: http://bzr.mozilla.org/bugzilla/3.6/revision/7251
Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=753447

--- a/Bugzilla/Bug.pm	2010-10-28 15:27:58 +0000
+++ b/Bugzilla/Bug.pm	2011-08-04 20:13:15 +0000
@@ -1403,7 +1403,7 @@
             || ThrowUserError("invalid_group_ID");
 
         # This can only happen if somebody hacked the enter_bug form.
-        ThrowCodeError("inactive_group", { name => $group->name })
+        ThrowCodeError("inactive_group", { group_id => $id })
             unless $group->is_active;
 
         my $membercontrol = $controls->{$id}

--- a/template/en/default/global/code-error.html.tmpl	2010-12-30 16:50:29 +0000
+++ b/template/en/default/global/code-error.html.tmpl	2011-08-04 20:13:15 +0000
@@ -217,8 +217,8 @@
     A legal [% field FILTER html %] was not set.
 
   [% ELSIF error == "inactive_group" %]
-    Attempted to add [% terms.bug %] to the '[% name FILTER html %]'
-    group, which is not used for [% terms.bugs %].
+    Attempted to add [% terms.abug %] to group ID [% group_id FILTER html %],
+    which is not used for [% terms.bugs %].
 
   [% ELSIF error == "invalid_attach_id_to_obsolete" %]
      The attachment number of one of the attachments you wanted to obsolete,

