#!/bin/sh
# CVE-2010-4572
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

Description: chart.cgi vulnerable to header-injection
 CVE-2010-4572 chart.cgi vulnerable to header-injection due to use of |print "Location:"|
 instead of $cgi->redirect
Origin: http://bzr.mozilla.org/bugzilla/3.6/revision/7223
Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=621572
Bug-Debian: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=611176

--- a/chart.cgi	2011-01-24 17:15:40 +0000
+++ b/chart.cgi	2011-01-24 18:14:09 +0000
@@ -74,8 +74,8 @@
 # Go back to query.cgi if we are adding a boolean chart parameter.
 if (grep(/^cmd-/, $cgi->param())) {
     my $params = $cgi->canonicalise_query("format", "ctype", "action");
-    print "Location: query.cgi?format=" . $cgi->param('query_format') .
-                                          ($params ? "&$params" : "") . "\n\n";
+    print $cgi->redirect("query.cgi?format=" . $cgi->param('query_format') .
+                                               ($params ? "&$params" : ""));
     exit(0);
 }
 
@@ -98,7 +98,7 @@
 # Go to buglist.cgi if we are doing a search.
 if ($action eq "search") {
     my $params = $cgi->canonicalise_query("format", "ctype", "action");
-    print "Location: buglist.cgi" . ($params ? "?$params" : "") . "\n\n";
+    print $cgi->redirect("buglist.cgi" . ($params ? "?$params" : ""));
     exit(0);
 }
 
