/*@-bounds@*/
#include "system.h"
#include <rpmlib.h>

/*@observer@*/ /*@unchecked@*/
static const struct headerTagTableEntry_s rpmTagTbl[] = {
	{ "RPMTAG_HEADERIMAGE",	HEADER_IMAGE,	RPM_NULL_TYPE },
	{ "RPMTAG_HEADERSIGNATURES",	HEADER_SIGNATURES,	RPM_NULL_TYPE },
	{ "RPMTAG_HEADERIMMUTABLE",	HEADER_IMMUTABLE,	RPM_NULL_TYPE },
	{ "RPMTAG_HEADERREGIONS",	HEADER_REGIONS,	RPM_NULL_TYPE },
	{ "RPMTAG_HEADERI18NTABLE",	HEADER_I18NTABLE,	RPM_NULL_TYPE },
	{ "RPMTAG_SIGSIZE",	RPMTAG_SIG_BASE+1,	RPM_INT32_TYPE },
	{ "RPMTAG_SIGPGP",	RPMTAG_SIG_BASE+3,	RPM_BIN_TYPE },
	{ "RPMTAG_SIGMD5",	RPMTAG_SIG_BASE+5,	RPM_BIN_TYPE },
	{ "RPMTAG_PKGID",	RPMTAG_SIGMD5,	RPM_BIN_TYPE },
	{ "RPMTAG_SIGGPG",	RPMTAG_SIG_BASE+6,	RPM_BIN_TYPE },
	{ "RPMTAG_PUBKEYS",	RPMTAG_SIG_BASE+10,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_DSAHEADER",	RPMTAG_SIG_BASE+11,	RPM_BIN_TYPE },
	{ "RPMTAG_RSAHEADER",	RPMTAG_SIG_BASE+12,	RPM_BIN_TYPE },
	{ "RPMTAG_SHA1HEADER",	RPMTAG_SIG_BASE+13,	RPM_STRING_TYPE },
	{ "RPMTAG_HDRID",	RPMTAG_SHA1HEADER,	RPM_STRING_TYPE },
	{ "RPMTAG_NAME",	1000,	RPM_STRING_TYPE },
	{ "RPMTAG_N",	RPMTAG_NAME,	RPM_STRING_TYPE },
	{ "RPMTAG_VERSION",	1001,	RPM_STRING_TYPE },
	{ "RPMTAG_V",	RPMTAG_VERSION,	RPM_STRING_TYPE },
	{ "RPMTAG_RELEASE",	1002,	RPM_STRING_TYPE },
	{ "RPMTAG_R",	RPMTAG_RELEASE,	RPM_STRING_TYPE },
	{ "RPMTAG_EPOCH",	1003,	RPM_INT32_TYPE },
	{ "RPMTAG_E",	RPMTAG_EPOCH,	RPM_INT32_TYPE },
	{ "RPMTAG_SERIAL",	RPMTAG_EPOCH,	RPM_INT32_TYPE },
	{ "RPMTAG_SUMMARY",	1004,	RPM_I18NSTRING_TYPE },
	{ "RPMTAG_DESCRIPTION",	1005,	RPM_I18NSTRING_TYPE },
	{ "RPMTAG_BUILDTIME",	1006,	RPM_INT32_TYPE },
	{ "RPMTAG_BUILDHOST",	1007,	RPM_STRING_TYPE },
	{ "RPMTAG_INSTALLTIME",	1008,	RPM_INT32_TYPE },
	{ "RPMTAG_SIZE",	1009,	RPM_INT32_TYPE },
	{ "RPMTAG_DISTRIBUTION",	1010,	RPM_STRING_TYPE },
	{ "RPMTAG_VENDOR",	1011,	RPM_STRING_TYPE },
	{ "RPMTAG_GIF",	1012,	RPM_BIN_TYPE },
	{ "RPMTAG_XPM",	1013,	RPM_BIN_TYPE },
	{ "RPMTAG_LICENSE",	1014,	RPM_STRING_TYPE },
	{ "RPMTAG_COPYRIGHT",	RPMTAG_LICENSE,	RPM_STRING_TYPE },
	{ "RPMTAG_PACKAGER",	1015,	RPM_STRING_TYPE },
	{ "RPMTAG_GROUP",	1016,	RPM_I18NSTRING_TYPE },
	{ "RPMTAG_SOURCE",	1018,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_PATCH",	1019,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_URL",	1020,	RPM_STRING_TYPE },
	{ "RPMTAG_OS",	1021,	RPM_STRING_TYPE },
	{ "RPMTAG_ARCH",	1022,	RPM_STRING_TYPE },
	{ "RPMTAG_PREIN",	1023,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTIN",	1024,	RPM_STRING_TYPE },
	{ "RPMTAG_PREUN",	1025,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTUN",	1026,	RPM_STRING_TYPE },
	{ "RPMTAG_OLDFILENAMES",	1027,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FILESIZES",	1028,	RPM_INT32_TYPE },
	{ "RPMTAG_FILESTATES",	1029,	RPM_CHAR_TYPE },
	{ "RPMTAG_FILEMODES",	1030,	RPM_INT16_TYPE },
	{ "RPMTAG_FILERDEVS",	1033,	RPM_INT16_TYPE },
	{ "RPMTAG_FILEMTIMES",	1034,	RPM_INT32_TYPE },
	{ "RPMTAG_FILEMD5S",	1035,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FILELINKTOS",	1036,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FILEFLAGS",	1037,	RPM_INT32_TYPE },
	{ "RPMTAG_FILEUSERNAME",	1039,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FILEGROUPNAME",	1040,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_ICON",	1043,	RPM_NULL_TYPE },
	{ "RPMTAG_SOURCERPM",	1044,	RPM_STRING_TYPE },
	{ "RPMTAG_FILEVERIFYFLAGS",	1045,	RPM_INT32_TYPE },
	{ "RPMTAG_ARCHIVESIZE",	1046,	RPM_INT32_TYPE },
	{ "RPMTAG_PROVIDENAME",	1047,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_PROVIDES",	RPMTAG_PROVIDENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_P",	RPMTAG_PROVIDENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_REQUIREFLAGS",	1048,	RPM_INT32_TYPE },
	{ "RPMTAG_REQUIRENAME",	1049,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_REQUIRES",	RPMTAG_REQUIRENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_D",	RPMTAG_REQUIRENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_REQUIREVERSION",	1050,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_CONFLICTFLAGS",	1053,	RPM_INT32_TYPE },
	{ "RPMTAG_CONFLICTNAME",	1054,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_CONFLICTS",	RPMTAG_CONFLICTNAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_C",	RPMTAG_CONFLICTNAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_CONFLICTVERSION",	1055,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_EXCLUDEARCH",	1059,	RPM_NULL_TYPE },
	{ "RPMTAG_EXCLUDEOS",	1060,	RPM_NULL_TYPE },
	{ "RPMTAG_EXCLUSIVEARCH",	1061,	RPM_NULL_TYPE },
	{ "RPMTAG_EXCLUSIVEOS",	1062,	RPM_NULL_TYPE },
	{ "RPMTAG_RPMVERSION",	1064,	RPM_STRING_TYPE },
	{ "RPMTAG_TRIGGERSCRIPTS",	1065,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_TRIGGERNAME",	1066,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_TRIGGERVERSION",	1067,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_TRIGGERFLAGS",	1068,	RPM_INT32_TYPE },
	{ "RPMTAG_TRIGGERINDEX",	1069,	RPM_INT32_TYPE },
	{ "RPMTAG_VERIFYSCRIPT",	1079,	RPM_STRING_TYPE },
	{ "RPMTAG_CHANGELOGTIME",	1080,	RPM_INT32_TYPE },
	{ "RPMTAG_CHANGELOGNAME",	1081,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_CHANGELOGTEXT",	1082,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_PREINPROG",	1085,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTINPROG",	1086,	RPM_STRING_TYPE },
	{ "RPMTAG_PREUNPROG",	1087,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTUNPROG",	1088,	RPM_STRING_TYPE },
	{ "RPMTAG_BUILDARCHS",	1089,	RPM_NULL_TYPE },
	{ "RPMTAG_OBSOLETENAME",	1090,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_OBSOLETES",	RPMTAG_OBSOLETENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_O",	RPMTAG_OBSOLETENAME,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_VERIFYSCRIPTPROG",	1091,	RPM_STRING_TYPE },
	{ "RPMTAG_TRIGGERSCRIPTPROG",	1092,	RPM_STRING_TYPE },
	{ "RPMTAG_COOKIE",	1094,	RPM_STRING_TYPE },
	{ "RPMTAG_FILEDEVICES",	1095,	RPM_INT32_TYPE },
	{ "RPMTAG_FILEINODES",	1096,	RPM_INT32_TYPE },
	{ "RPMTAG_FILELANGS",	1097,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_PREFIXES",	1098,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_INSTPREFIXES",	1099,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_SOURCEPACKAGE",	1106,	RPM_INT32_TYPE },
	{ "RPMTAG_PROVIDEFLAGS",	1112,	RPM_INT32_TYPE },
	{ "RPMTAG_PROVIDEVERSION",	1113,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_OBSOLETEFLAGS",	1114,	RPM_INT32_TYPE },
	{ "RPMTAG_OBSOLETEVERSION",	1115,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_DIRINDEXES",	1116,	RPM_INT32_TYPE },
	{ "RPMTAG_BASENAMES",	1117,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_DIRNAMES",	1118,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_OPTFLAGS",	1122,	RPM_STRING_TYPE },
	{ "RPMTAG_DISTURL",	1123,	RPM_STRING_TYPE },
	{ "RPMTAG_PAYLOADFORMAT",	1124,	RPM_STRING_TYPE },
	{ "RPMTAG_PAYLOADCOMPRESSOR",	1125,	RPM_STRING_TYPE },
	{ "RPMTAG_PAYLOADFLAGS",	1126,	RPM_STRING_TYPE },
	{ "RPMTAG_INSTALLCOLOR",	1127,	RPM_INT32_TYPE },
	{ "RPMTAG_INSTALLTID",	1128,	RPM_INT32_TYPE },
	{ "RPMTAG_REMOVETID",	1129,	RPM_INT32_TYPE },
	{ "RPMTAG_RHNPLATFORM",	1131,	RPM_STRING_TYPE },
	{ "RPMTAG_PLATFORM",	1132,	RPM_STRING_TYPE },
	{ "RPMTAG_PATCHESNAME",	1133,	RPM_NULL_TYPE },
	{ "RPMTAG_PATCHESFLAGS",	1134,	RPM_NULL_TYPE },
	{ "RPMTAG_PATCHESVERSION",	1135,	RPM_NULL_TYPE },
	{ "RPMTAG_CACHECTIME",	1136,	RPM_INT32_TYPE },
	{ "RPMTAG_CACHEPKGPATH",	1137,	RPM_STRING_TYPE },
	{ "RPMTAG_CACHEPKGSIZE",	1138,	RPM_INT32_TYPE },
	{ "RPMTAG_CACHEPKGMTIME",	1139,	RPM_INT32_TYPE },
	{ "RPMTAG_FILECOLORS",	1140,	RPM_INT32_TYPE },
	{ "RPMTAG_FILECLASS",	1141,	RPM_INT32_TYPE },
	{ "RPMTAG_CLASSDICT",	1142,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FILEDEPENDSX",	1143,	RPM_INT32_TYPE },
	{ "RPMTAG_FILEDEPENDSN",	1144,	RPM_INT32_TYPE },
	{ "RPMTAG_DEPENDSDICT",	1145,	RPM_INT32_TYPE },
	{ "RPMTAG_SOURCEPKGID",	1146,	RPM_BIN_TYPE },
	{ "RPMTAG_FILECONTEXTS",	1147,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_FSCONTEXTS",	1148,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_RECONTEXTS",	1149,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_POLICIES",	1150,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_PRETRANS",	1151,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTTRANS",	1152,	RPM_STRING_TYPE },
	{ "RPMTAG_PRETRANSPROG",	1153,	RPM_STRING_TYPE },
	{ "RPMTAG_POSTTRANSPROG",	1154,	RPM_STRING_TYPE },
	{ "RPMTAG_DISTTAG",	1155,	RPM_STRING_TYPE },
	{ "RPMTAG_SUGGESTSNAME",	1156,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_SUGGESTSVERSION",	1157,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_SUGGESTSFLAGS",	1158,	RPM_INT32_TYPE },
	{ "RPMTAG_ENHANCESNAME",	1159,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_ENHANCESVERSION",	1160,	RPM_STRING_ARRAY_TYPE },
	{ "RPMTAG_ENHANCESFLAGS",	1161,	RPM_INT32_TYPE },
	{ "RPMTAG_PRIORITY",	1162,	RPM_INT32_TYPE },
	{ NULL, 0, 0 }
};

/*@observer@*/ /*@unchecked@*/
const struct headerTagTableEntry_s * rpmTagTable = rpmTagTbl;

/*@unchecked@*/
const int rpmTagTableSize = sizeof(rpmTagTbl) / sizeof(rpmTagTbl[0]) - 1;
/*@=bounds@*/
